/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.services.clientpolicy.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.TokenRequestContext;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientScopesCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientScopesCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientScopesCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                if (this.isScopeMatched(((AuthorizationRequestContext)context).getAuthorizationEndpointRequest())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case TOKEN_REQUEST: {
                if (this.isScopeMatched(((TokenRequestContext)context).getParseResult().getClientSession())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    private boolean isScopeMatched(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            return false;
        }
        return this.isScopeMatched(clientSession.getNote("scope"), clientSession.getClient());
    }

    private boolean isScopeMatched(AuthorizationEndpointRequest request) {
        if (request == null) {
            return false;
        }
        return this.isScopeMatched(request.getScope(), this.session.getContext().getRealm().getClientByClientId(request.getClientId()));
    }

    private boolean isScopeMatched(String explicitScopes, ClientModel client) {
        boolean isDefaultScope;
        if (explicitScopes == null) {
            explicitScopes = "";
        }
        HashSet<String> explicitSpecifiedScopes = new HashSet<String>(Arrays.asList(explicitScopes.split(" ")));
        Set defaultScopes = client.getClientScopes(true, true).keySet();
        Set optionalScopes = client.getClientScopes(false, true).keySet();
        ArrayList expectedScopes = (ArrayList)this.componentModel.getConfig().get((Object)"scopes");
        if (expectedScopes == null) {
            expectedScopes = new ArrayList();
        }
        if (logger.isTraceEnabled()) {
            explicitSpecifiedScopes.stream().forEach(i -> ClientPolicyLogger.log(logger, " explicit specified client scope = " + i));
            defaultScopes.stream().forEach(i -> ClientPolicyLogger.log(logger, " default client scope = " + i));
            optionalScopes.stream().forEach(i -> ClientPolicyLogger.log(logger, " optional client scope = " + i));
            expectedScopes.stream().forEach(i -> ClientPolicyLogger.log(logger, " expected scope = " + i));
        }
        if (isDefaultScope = "Default".equals(this.componentModel.getConfig().getFirst((Object)"type"))) {
            expectedScopes.retainAll(defaultScopes);
            return !expectedScopes.isEmpty();
        }
        explicitSpecifiedScopes.retainAll(expectedScopes);
        explicitSpecifiedScopes.retainAll(optionalScopes);
        if (!explicitSpecifiedScopes.isEmpty()) {
            explicitSpecifiedScopes.stream().forEach(i -> ClientPolicyLogger.log(logger, " matched scope = " + i));
            return true;
        }
        return false;
    }
}

