/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureSigningAlgorithmEnforceExecutor
implements ClientPolicyExecutorProvider {
    private static final Logger logger = Logger.getLogger(SecureSigningAlgorithmEnforceExecutor.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;
    private static final List<String> sigTargets = Arrays.asList("user.info.response.signature.alg", "request.object.signature.alg", "id.token.signed.response.alg", "token.endpoint.auth.signing.alg");
    private static final List<String> sigTargetsAdminRestApiOnly = Arrays.asList("access.token.signed.response.alg");

    public SecureSigningAlgorithmEnforceExecutor(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    this.verifySecureSigningAlgorithm(((AdminClientRegisterContext)context).getProposedClientRepresentation(), true, false);
                    break;
                }
                if (context instanceof DynamicClientRegisterContext) {
                    this.verifySecureSigningAlgorithm(((DynamicClientRegisterContext)context).getProposedClientRepresentation(), false, false);
                    break;
                }
                throw new ClientPolicyException("invalid_request", "not allowed input format.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    this.verifySecureSigningAlgorithm(((AdminClientUpdateContext)context).getProposedClientRepresentation(), true, true);
                    break;
                }
                if (context instanceof DynamicClientUpdateContext) {
                    this.verifySecureSigningAlgorithm(((DynamicClientUpdateContext)context).getProposedClientRepresentation(), false, true);
                    break;
                }
                throw new ClientPolicyException("invalid_request", "not allowed input format.");
            }
            default: {
                return;
            }
        }
    }

    private void verifySecureSigningAlgorithm(ClientRepresentation clientRep, boolean byAdminRestApi, boolean isUpdate) throws ClientPolicyException {
        if (clientRep.getAttributes() == null) {
            throw new ClientPolicyException("invalid_request", "no signature algorithm was specified.");
        }
        for (String sigTarget : sigTargets) {
            this.verifySecureSigningAlgorithm(sigTarget, (String)clientRep.getAttributes().get(sigTarget));
        }
        if (byAdminRestApi) {
            for (String sigTarget : sigTargetsAdminRestApiOnly) {
                this.verifySecureSigningAlgorithm(sigTarget, (String)clientRep.getAttributes().get(sigTarget));
            }
        }
    }

    private void verifySecureSigningAlgorithm(String sigTarget, String sigAlg) throws ClientPolicyException {
        if (sigAlg == null) {
            ClientPolicyLogger.logv(logger, "Signing algorithm not specified explicitly. signature target = {0}", sigTarget);
            return;
        }
        switch (sigAlg) {
            case "PS256": 
            case "PS384": 
            case "PS512": 
            case "ES256": 
            case "ES384": 
            case "ES512": {
                ClientPolicyLogger.logv(logger, "Passed. signature target = {0}, signature algorithm = {1}", sigTarget, sigAlg);
                return;
            }
        }
        ClientPolicyLogger.logv(logger, "NOT allowed signatureAlgorithm. signature target = {0}, signature algorithm = {1}", sigTarget, sigAlg);
        throw new ClientPolicyException("invalid_request", "not allowed signature algorithm.");
    }
}

