/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.resources.admin.ClientScopeEvaluateScopeMappingsResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class ClientScopeEvaluateResource {
    protected static final Logger logger = Logger.getLogger(ClientScopeEvaluateResource.class);
    private final RealmModel realm;
    private final ClientModel client;
    private final AdminPermissionEvaluator auth;
    private final UriInfo uriInfo;
    private final KeycloakSession session;
    private final ClientConnection clientConnection;

    public ClientScopeEvaluateResource(KeycloakSession session, UriInfo uriInfo, RealmModel realm, AdminPermissionEvaluator auth, ClientModel client, ClientConnection clientConnection) {
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.client = client;
        this.auth = auth;
        this.session = session;
        this.clientConnection = clientConnection;
    }

    @Path(value="scope-mappings/{roleContainerId}")
    public ClientScopeEvaluateScopeMappingsResource scopeMappings(@QueryParam(value="scope") String scopeParam, @PathParam(value="roleContainerId") String roleContainerId) {
        RealmModel roleContainer;
        this.auth.clients().requireView(this.client);
        if (roleContainerId == null) {
            throw new NotFoundException("No roleContainerId provided");
        }
        Object object = roleContainer = roleContainerId.equals(this.realm.getName()) ? this.realm : this.realm.getClientById(roleContainerId);
        if (roleContainer == null) {
            throw new NotFoundException("Role Container not found");
        }
        return new ClientScopeEvaluateScopeMappingsResource((RoleContainerModel)roleContainer, this.auth, this.client, scopeParam, this.session);
    }

    @GET
    @Path(value="protocol-mappers")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<ProtocolMapperEvaluationRepresentation> getGrantedProtocolMappers(@QueryParam(value="scope") String scopeParam) {
        this.auth.clients().requireView(this.client);
        return TokenManager.getRequestedClientScopes(scopeParam, this.client).flatMap(mapperContainer -> mapperContainer.getProtocolMappersStream().filter(current -> ProtocolMapperUtils.isEnabled(this.session, current) && Objects.equals(current.getProtocol(), this.client.getProtocol())).map(current -> this.toProtocolMapperEvaluationRepresentation((ProtocolMapperModel)current, (ClientScopeModel)mapperContainer)));
    }

    private ProtocolMapperEvaluationRepresentation toProtocolMapperEvaluationRepresentation(ProtocolMapperModel mapper, ClientScopeModel mapperContainer) {
        ProtocolMapperEvaluationRepresentation rep = new ProtocolMapperEvaluationRepresentation();
        rep.setMapperId(mapper.getId());
        rep.setMapperName(mapper.getName());
        rep.setProtocolMapper(mapper.getProtocolMapper());
        if (mapperContainer.getId().equals(this.client.getId())) {
            rep.setContainerId(this.client.getId());
            rep.setContainerName("");
            rep.setContainerType("client");
        } else {
            ClientScopeModel clientScope = mapperContainer;
            rep.setContainerId(clientScope.getId());
            rep.setContainerName(clientScope.getName());
            rep.setContainerType("client-scope");
        }
        return rep;
    }

    @GET
    @Path(value="generate-example-access-token")
    @NoCache
    @Produces(value={"application/json"})
    public AccessToken generateExampleAccessToken(@QueryParam(value="scope") String scopeParam, @QueryParam(value="userId") String userId) {
        this.auth.clients().requireView(this.client);
        if (userId == null) {
            throw new NotFoundException("No userId provided");
        }
        UserModel user = this.session.users().getUserById(userId, this.realm);
        if (user == null) {
            throw new NotFoundException("No user found");
        }
        logger.debugf("generateExampleAccessToken invoked. User: %s, Scope param: %s", (Object)user.getUsername(), (Object)scopeParam);
        AccessToken token = this.generateToken(user, scopeParam);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessToken generateToken(UserModel user, String scopeParam) {
        AuthenticationSessionModel authSession = null;
        UserSessionModel userSession = null;
        AuthenticationSessionManager authSessionManager = new AuthenticationSessionManager(this.session);
        try {
            RootAuthenticationSessionModel rootAuthSession = authSessionManager.createAuthenticationSession(this.realm, false);
            authSession = rootAuthSession.createAuthenticationSession(this.client);
            authSession.setAuthenticatedUser(user);
            authSession.setProtocol("openid-connect");
            authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
            authSession.setClientNote("scope", scopeParam);
            userSession = this.session.sessions().createUserSession(authSession.getParentSession().getId(), this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "example-auth", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
            AuthenticationManager.setClientScopesInSession(authSession);
            ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
            TokenManager tokenManager = new TokenManager();
            TokenManager.AccessTokenResponseBuilder responseBuilder = tokenManager.responseBuilder(this.realm, this.client, null, this.session, userSession, clientSessionCtx).generateAccessToken();
            AccessToken accessToken = responseBuilder.getAccessToken();
            if (authSession != null) {
                authSessionManager.removeAuthenticationSession(this.realm, authSession, false);
            }
            return accessToken;
        }
        catch (Throwable throwable) {
            if (authSession != null) {
                authSessionManager.removeAuthenticationSession(this.realm, authSession, false);
            }
            throw throwable;
        }
    }

    public static class ProtocolMapperEvaluationRepresentation {
        @JsonProperty(value="mapperId")
        private String mapperId;
        @JsonProperty(value="mapperName")
        private String mapperName;
        @JsonProperty(value="containerId")
        private String containerId;
        @JsonProperty(value="containerName")
        private String containerName;
        @JsonProperty(value="containerType")
        private String containerType;
        @JsonProperty(value="protocolMapper")
        private String protocolMapper;

        public String getMapperId() {
            return this.mapperId;
        }

        public void setMapperId(String mapperId) {
            this.mapperId = mapperId;
        }

        public String getMapperName() {
            return this.mapperName;
        }

        public void setMapperName(String mapperName) {
            this.mapperName = mapperName;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public String getContainerType() {
            return this.containerType;
        }

        public void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        public String getProtocolMapper() {
            return this.protocolMapper;
        }

        public void setProtocolMapper(String protocolMapper) {
            this.protocolMapper = protocolMapper;
        }
    }
}

