/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperUtils;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperValidator;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.validation.ClientValidationContext;
import org.keycloak.validation.ClientValidationProvider;
import org.keycloak.validation.ValidationContext;
import org.keycloak.validation.ValidationResult;

public class DefaultClientValidationProvider
implements ClientValidationProvider {
    public ValidationResult validate(ValidationContext<ClientModel> context) {
        this.validateUrls(context);
        this.validatePairwiseInClientModel(context);
        return context.toResult();
    }

    public ValidationResult validate(ClientValidationContext.OIDCContext context) {
        this.validateUrls((ValidationContext<ClientModel>)context);
        this.validatePairwiseInOIDCClient(context);
        return context.toResult();
    }

    private void validateUrls(ValidationContext<ClientModel> context) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        String authServerUrl = "https://localhost/auth";
        String rootUrl = ResolveRelative.resolveRootUrl(authServerUrl, authServerUrl, client.getRootUrl());
        String baseUrl = ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, authServerUrl, client.getBaseUrl());
        String backchannelLogoutUrl = OIDCAdvancedConfigWrapper.fromClientModel(client).getBackchannelLogoutUrl();
        String resolvedBackchannelLogoutUrl = ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, authServerUrl, backchannelLogoutUrl);
        this.checkUri(FieldMessages.ROOT_URL, rootUrl, context, true, true);
        this.checkUri(FieldMessages.BASE_URL, baseUrl, context, true, false);
        this.checkUri(FieldMessages.BACKCHANNEL_LOGOUT_URL, resolvedBackchannelLogoutUrl, context, true, false);
        client.getRedirectUris().stream().map(u -> ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, rootUrl, u)).forEach(u -> this.checkUri(FieldMessages.REDIRECT_URIS, (String)u, context, false, true));
    }

    private void checkUri(FieldMessages field, String url, ValidationContext<ClientModel> context, boolean checkValidUrl, boolean checkFragment) {
        if (url == null || url.isEmpty()) {
            return;
        }
        try {
            URI uri = new URI(url);
            boolean valid = true;
            if (uri.getScheme() != null && (uri.getScheme().equals("data") || uri.getScheme().equals("javascript"))) {
                context.addError(field.getFieldId(), field.getScheme(), field.getSchemeKey(), new Object[0]);
                valid = false;
            }
            if (checkFragment && uri.getFragment() != null) {
                context.addError(field.getFieldId(), field.getFragment(), field.getFragmentKey(), new Object[0]);
                valid = false;
            }
            if (checkValidUrl && valid) {
                uri.toURL();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            context.addError(field.getFieldId(), field.getInvalid(), field.getInvalidKey(), new Object[0]);
        }
    }

    private void validatePairwiseInClientModel(ValidationContext<ClientModel> context) {
        List<ProtocolMapperRepresentation> foundPairwiseMappers = PairwiseSubMapperUtils.getPairwiseSubMappers(ModelToRepresentation.toRepresentation((ClientModel)((ClientModel)context.getObjectToValidate()), (KeycloakSession)context.getSession()));
        for (ProtocolMapperRepresentation foundPairwise : foundPairwiseMappers) {
            String sectorIdentifierUri = PairwiseSubMapperHelper.getSectorIdentifierUri(foundPairwise);
            this.validatePairwise(context, sectorIdentifierUri);
        }
    }

    private void validatePairwiseInOIDCClient(ClientValidationContext.OIDCContext context) {
        OIDCClientRepresentation oidcRep = context.getOIDCClient();
        SubjectType subjectType = SubjectType.parse(oidcRep.getSubjectType());
        String sectorIdentifierUri = oidcRep.getSectorIdentifierUri();
        if (SubjectType.PAIRWISE == subjectType || sectorIdentifierUri != null && !sectorIdentifierUri.isEmpty()) {
            this.validatePairwise((ValidationContext<ClientModel>)context, oidcRep.getSectorIdentifierUri());
        }
    }

    private void validatePairwise(ValidationContext<ClientModel> context, String sectorIdentifierUri) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        String rootUrl = client.getRootUrl();
        HashSet<String> redirectUris = new HashSet<String>();
        if (client.getRedirectUris() != null) {
            redirectUris.addAll(client.getRedirectUris());
        }
        try {
            PairwiseSubMapperValidator.validate(context.getSession(), rootUrl, redirectUris, sectorIdentifierUri);
        }
        catch (ProtocolMapperConfigException e) {
            context.addError("pairWise", e.getMessage(), e.getMessageKey(), new Object[0]);
        }
    }

    private static enum FieldMessages {
        ROOT_URL("rootUrl", "Root URL is not a valid URL", "clientRootURLInvalid", "Root URL must not contain an URL fragment", "clientRootURLFragmentError", "Root URL uses an illegal scheme", "clientRootURLIllegalSchemeError"),
        BASE_URL("baseUrl", "Base URL is not a valid URL", "clientBaseURLInvalid", null, null, "Base URL uses an illegal scheme", "clientBaseURLIllegalSchemeError"),
        REDIRECT_URIS("redirectUris", "A redirect URI is not a valid URI", "clientRedirectURIsInvalid", "Redirect URIs must not contain an URI fragment", "clientRedirectURIsFragmentError", "A redirect URI uses an illegal scheme", "clientRedirectURIsIllegalSchemeError"),
        BACKCHANNEL_LOGOUT_URL("backchannelLogoutUrl", "Backchannel logout URL is not a valid URL", "backchannelLogoutUrlIsInvalid", null, null, "Backchannel logout URL uses an illegal scheme", "backchannelLogoutUrlIllegalSchemeError");

        private String fieldId;
        private String invalid;
        private String invalidKey;
        private String fragment;
        private String fragmentKey;
        private String scheme;
        private String schemeKey;

        private FieldMessages(String fieldId, String invalid, String invalidKey, String fragment, String fragmentKey, String scheme, String schemeKey) {
            this.fieldId = fieldId;
            this.invalid = invalid;
            this.invalidKey = invalidKey;
            this.fragment = fragment;
            this.fragmentKey = fragmentKey;
            this.scheme = scheme;
            this.schemeKey = schemeKey;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getInvalid() {
            return this.invalid;
        }

        public String getInvalidKey() {
            return this.invalidKey;
        }

        public String getFragment() {
            return this.fragment;
        }

        public String getFragmentKey() {
            return this.fragmentKey;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getSchemeKey() {
            return this.schemeKey;
        }
    }
}

