/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.DisplayTypeRequiredActionFactory;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.ConsoleUpdateProfile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class VerifyUserProfile
implements RequiredActionProvider,
RequiredActionFactory,
DisplayTypeRequiredActionFactory {
    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
        UserModel user = context.getUser();
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, user);
        try {
            profile.validate();
            context.getAuthenticationSession().removeRequiredAction(this.getId());
            user.removeRequiredAction(this.getId());
        }
        catch (ValidationException e) {
            context.getAuthenticationSession().addRequiredAction(this.getId());
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, context.getUser());
        try {
            profile.validate();
            context.success();
        }
        catch (ValidationException ve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(ve.getErrors());
            Object parameters = context.getHttpRequest().getHttpMethod().equalsIgnoreCase("GET") ? new MultivaluedHashMap() : context.getHttpRequest().getDecodedFormParameters();
            context.challenge(this.createResponse(context, profile, (MultivaluedMap<String, String>)parameters, errors));
        }
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.VERIFY_PROFILE);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (!context.getRealm().isEditUsernameAllowed()) {
            formData.putSingle((Object)"username", (Object)context.getUser().getUsername());
        }
        UserProfileProvider provider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
        UserProfile profile = provider.create(UserProfileContext.UPDATE_PROFILE, (Map)formData, context.getUser());
        try {
            profile.update(new BiConsumer[0]);
            context.success();
        }
        catch (ValidationException ve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(ve.getErrors());
            context.challenge(this.createResponse(context, profile, (MultivaluedMap<String, String>)formData, errors));
        }
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public RequiredActionProvider createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this;
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return ConsoleUpdateProfile.SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Verify Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.VERIFY_PROFILE.name();
    }

    private Response createResponse(RequiredActionContext context, UserProfile profile, MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        LoginFormsProvider form = context.form();
        if (!errors.isEmpty()) {
            form.setErrors(errors);
        }
        return form.setFormData(formData).createResponse(UserModel.RequiredAction.VERIFY_PROFILE);
    }
}

