/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.TokenVerifier;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceTokenStoreProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.AbstractCibaEndpoint;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;

public class BackchannelAuthenticationCallbackEndpoint
extends AbstractCibaEndpoint {
    @Context
    private HttpRequest httpRequest;

    public BackchannelAuthenticationCallbackEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
    }

    @Path(value="/")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response processAuthenticationChannelResult(AuthenticationChannelResponse response) {
        this.event.event(EventType.LOGIN);
        AccessToken bearerToken = this.verifyAuthenticationRequest(this.httpRequest.getHttpHeaders());
        AuthenticationChannelResponse.Status status = response.getStatus();
        if (status == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_request", "Invalid authentication status", Response.Status.BAD_REQUEST);
        }
        switch (status) {
            case SUCCEED: {
                this.approveRequest(bearerToken);
                break;
            }
            case CANCELLED: 
            case UNAUTHORIZED: {
                this.denyRequest(bearerToken, status);
            }
        }
        return Response.ok((Object)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private AccessToken verifyAuthenticationRequest(HttpHeaders headers) {
        AccessToken bearerToken;
        String rawBearerToken = AppAuthManager.extractAuthorizationHeaderTokenOrReturnNull(headers);
        if (rawBearerToken == null) {
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.UNAUTHORIZED);
        }
        try {
            bearerToken = (AccessToken)TokenVerifier.createWithoutSignature((JsonWebToken)((JsonWebToken)this.session.tokens().decode(rawBearerToken, AccessToken.class))).withDefaultChecks().realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName())).checkActive(true).audience(new String[]{Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName())}).verify().getToken();
        }
        catch (Exception e) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        OAuth2DeviceCodeModel deviceCode = store.getByUserCode(this.realm, bearerToken.getId());
        if (deviceCode == null) {
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        if (!deviceCode.isPending()) {
            this.cancelRequest(bearerToken.getId());
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.FORBIDDEN);
        }
        ClientModel issuedFor = this.realm.getClientByClientId(bearerToken.getIssuedFor());
        if (issuedFor == null || !issuedFor.isEnabled()) {
            throw new ErrorResponseException("invalid_request", "Invalid token recipient", Response.Status.BAD_REQUEST);
        }
        if (!deviceCode.getClientId().equals(issuedFor.getClientId())) {
            throw new ErrorResponseException("invalid_request", "Token recipient mismatch", Response.Status.BAD_REQUEST);
        }
        this.event.client(issuedFor);
        return bearerToken;
    }

    private void cancelRequest(String authResultId) {
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        OAuth2DeviceCodeModel userCode = store.getByUserCode(this.realm, authResultId);
        store.removeDeviceCode(this.realm, userCode.getDeviceCode());
        store.removeUserCode(this.realm, authResultId);
    }

    private void approveRequest(AccessToken authReqId) {
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        store.approve(this.realm, authReqId.getId(), "fake");
    }

    private void denyRequest(AccessToken authReqId, AuthenticationChannelResponse.Status status) {
        if (AuthenticationChannelResponse.Status.CANCELLED.equals((Object)status)) {
            this.event.error("not_allowed");
        } else {
            this.event.error("consent_denied");
        }
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        store.deny(this.realm, authReqId.getId());
    }
}

