/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceTokenStoreProvider;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.CIBAAuthenticationRequest;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.AbstractCibaEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.resolvers.CIBALoginUserResolver;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.util.JsonSerialization;

public class BackchannelAuthenticationEndpoint
extends AbstractCibaEndpoint {
    private final RealmModel realm;

    public BackchannelAuthenticationEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
        this.realm = session.getContext().getRealm();
        event.event(EventType.LOGIN);
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response processGrantRequest(@Context HttpRequest httpRequest) {
        CIBAAuthenticationRequest request = this.authorizeClient((MultivaluedMap<String, String>)httpRequest.getDecodedFormParameters());
        try {
            String authReqId = request.serialize(this.session);
            AuthenticationChannelProvider provider = (AuthenticationChannelProvider)this.session.getProvider(AuthenticationChannelProvider.class);
            if (provider == null) {
                throw new RuntimeException("Authentication Channel Provider not found.");
            }
            CIBALoginUserResolver resolver = (CIBALoginUserResolver)this.session.getProvider(CIBALoginUserResolver.class);
            if (resolver == null) {
                throw new RuntimeException("CIBA Login User Resolver not setup properly.");
            }
            UserModel user = request.getUser();
            String infoUsedByAuthentication = resolver.getInfoUsedByAuthentication(user);
            if (provider.requestAuthentication(request, infoUsedByAuthentication)) {
                CibaConfig cibaPolicy = this.realm.getCibaPolicy();
                int poolingInterval = cibaPolicy.getPoolingInterval();
                this.storeAuthenticationRequest(request, cibaPolicy);
                ObjectNode response = JsonSerialization.createObjectNode();
                response.put("auth_req_id", authReqId).put("expires_in", cibaPolicy.getExpiresIn());
                if (poolingInterval > 0) {
                    response.put("interval", poolingInterval);
                }
                return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)response)).build();
            }
        }
        catch (Exception e) {
            throw new ErrorResponseException("server_error", "Failed to send authentication request", Response.Status.SERVICE_UNAVAILABLE);
        }
        throw new ErrorResponseException("server_error", "Unexpected response from authentication device", Response.Status.SERVICE_UNAVAILABLE);
    }

    private void storeAuthenticationRequest(CIBAAuthenticationRequest request, CibaConfig cibaConfig) {
        ClientModel client = request.getClient();
        int expiresIn = cibaConfig.getExpiresIn();
        int poolingInterval = cibaConfig.getPoolingInterval();
        OAuth2DeviceCodeModel deviceCode = OAuth2DeviceCodeModel.create((RealmModel)this.realm, (ClientModel)client, (String)request.getId(), (String)request.getScope(), null, (int)expiresIn, (int)poolingInterval, Collections.emptyMap());
        String authResultId = request.getAuthResultId();
        OAuth2DeviceUserCodeModel userCode = new OAuth2DeviceUserCodeModel(this.realm, deviceCode.getDeviceCode(), authResultId);
        int lifespanSeconds = expiresIn + poolingInterval + 10;
        OAuth2DeviceTokenStoreProvider store = (OAuth2DeviceTokenStoreProvider)this.session.getProvider(OAuth2DeviceTokenStoreProvider.class);
        store.put(deviceCode, userCode, lifespanSeconds);
    }

    private CIBAAuthenticationRequest authorizeClient(MultivaluedMap<String, String> params) {
        ClientModel client = this.authenticateClient();
        UserModel user = this.resolveUser(params, this.realm.getCibaPolicy().getAuthRequestedUserHint());
        CIBAAuthenticationRequest request = new CIBAAuthenticationRequest(this.session, user, client);
        request.setClient(client);
        String scope = (String)params.getFirst((Object)"scope");
        if (scope == null) {
            throw new ErrorResponseException("invalid_request", "missing parameter : scope", Response.Status.BAD_REQUEST);
        }
        request.setScope(scope);
        if (params.getFirst((Object)"binding_message") != null) {
            request.setBindingMessage((String)params.getFirst((Object)"binding_message"));
        }
        if (params.getFirst((Object)"acr_values") != null) {
            request.setAcrValues((String)params.getFirst((Object)"acr_values"));
        }
        CibaConfig policy = this.realm.getCibaPolicy();
        Integer expiresIn = policy.getExpiresIn();
        String requestedExpiry = (String)params.getFirst((Object)"requested_expiry");
        if (requestedExpiry != null) {
            expiresIn = Integer.valueOf(requestedExpiry);
        }
        request.exp(request.getIat() + expiresIn.longValue());
        StringBuilder scopes = new StringBuilder(Optional.ofNullable(request.getScope()).orElse(""));
        client.getClientScopes(true).forEach((key, value) -> {
            if (value.isDisplayOnConsentScreen()) {
                scopes.append(" ").append(value.getName());
            }
        });
        request.setScope(scopes.toString());
        String clientNotificationToken = (String)params.getFirst((Object)"client_notification_token");
        if (clientNotificationToken != null) {
            throw new ErrorResponseException("invalid_request", "Ping and push modes not supported. Use poll mode instead.", Response.Status.BAD_REQUEST);
        }
        String userCode = (String)params.getFirst((Object)"user_code");
        if (userCode != null) {
            throw new ErrorResponseException("invalid_request", "User code not supported", Response.Status.BAD_REQUEST);
        }
        return request;
    }

    private UserModel resolveUser(MultivaluedMap<String, String> params, String authRequestedUserHint) {
        UserModel user;
        CIBALoginUserResolver resolver = (CIBALoginUserResolver)this.session.getProvider(CIBALoginUserResolver.class);
        if (resolver == null) {
            throw new RuntimeException("CIBA Login User Resolver not setup properly.");
        }
        if (authRequestedUserHint.equals("login_hint")) {
            String userHint = (String)params.getFirst((Object)"login_hint");
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : login_hint", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromLoginHint(userHint);
        } else if (authRequestedUserHint.equals("id_token_hint")) {
            String userHint = (String)params.getFirst((Object)"id_token_hint");
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : id_token_hint", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromIdTokenHint(userHint);
        } else if (authRequestedUserHint.equals("login_hint_token")) {
            String userHint = (String)params.getFirst((Object)"login_hint_token");
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : login_hint_token", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromLoginHintToken(userHint);
        } else {
            throw new ErrorResponseException("invalid_request", "invalid user hint", Response.Status.BAD_REQUEST);
        }
        if (user == null || !user.isEnabled()) {
            throw new ErrorResponseException("invalid_request", "invalid user", Response.Status.BAD_REQUEST);
        }
        return user;
    }
}

