/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.w3c.dom.Element;

public class SamlSPDescriptorClientInstallation
implements ClientInstallationProvider {
    protected static final Logger logger = Logger.getLogger(SamlSPDescriptorClientInstallation.class);
    public static final String SAML_CLIENT_INSTALATION_SP_DESCRIPTOR = "saml-sp-descriptor";
    private static final String FALLBACK_ERROR_URL_STRING = "ERROR:ENDPOINT_NOT_SET";

    public static String getSPDescriptorForClient(ClientModel client) {
        try {
            String nameIdFormat;
            URI loginBinding;
            String logoutUrl;
            String assertionUrl;
            SamlClient samlClient = new SamlClient(client);
            URI logoutBinding = null;
            if (samlClient.forcePostBinding()) {
                assertionUrl = client.getAttribute("saml_assertion_consumer_url_post");
                logoutUrl = client.getAttribute("saml_single_logout_service_url_post");
                loginBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri();
            } else {
                assertionUrl = client.getAttribute("saml_assertion_consumer_url_redirect");
                logoutUrl = client.getAttribute("saml_single_logout_service_url_redirect");
                loginBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri();
            }
            if (samlClient.forceArtifactBinding()) {
                if (client.getAttribute("saml_single_logout_service_url_artifact") != null) {
                    logoutBinding = JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri();
                    logoutUrl = client.getAttribute("saml_single_logout_service_url_artifact");
                } else {
                    logoutBinding = loginBinding;
                }
                assertionUrl = client.getAttribute("saml_artifact_binding_url");
                loginBinding = JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri();
            }
            if (assertionUrl == null || assertionUrl.trim().isEmpty()) {
                assertionUrl = client.getManagementUrl();
            }
            if (assertionUrl == null || assertionUrl.trim().isEmpty()) {
                assertionUrl = FALLBACK_ERROR_URL_STRING;
            }
            if (logoutUrl == null || logoutUrl.trim().isEmpty()) {
                logoutUrl = client.getManagementUrl();
            }
            if (logoutUrl == null || logoutUrl.trim().isEmpty()) {
                logoutUrl = FALLBACK_ERROR_URL_STRING;
            }
            if (logoutBinding == null) {
                logoutBinding = loginBinding;
            }
            if ((nameIdFormat = samlClient.getNameIDFormat()) == null) {
                nameIdFormat = SamlProtocol.SAML_DEFAULT_NAMEID_FORMAT;
            }
            Element spCertificate = SPMetadataDescriptor.buildKeyInfoElement(null, (String)samlClient.getClientSigningCertificate());
            Element encCertificate = SPMetadataDescriptor.buildKeyInfoElement(null, (String)samlClient.getClientEncryptingCertificate());
            return SPMetadataDescriptor.getSPDescriptor((URI)loginBinding, (URI)logoutBinding, (URI)new URI(assertionUrl), (URI)new URI(logoutUrl), (boolean)samlClient.requiresClientSignature(), (boolean)samlClient.requiresAssertionSignature(), (boolean)samlClient.requiresEncryption(), (String)client.getClientId(), (String)nameIdFormat, Arrays.asList(spCertificate), Arrays.asList(encCertificate));
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot generate SP metadata", (Throwable)ex);
            return "";
        }
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        String descriptor = SamlSPDescriptorClientInstallation.getSPDescriptorForClient(client);
        return Response.ok((Object)descriptor, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "SAML Metadata SPSSODescriptor";
    }

    public String getHelpText() {
        return "SAML SP Metadata EntityDescriptor or rather SPSSODescriptor. This is an XML file.";
    }

    public String getFilename() {
        return "saml-sp-metadata.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return SAML_CLIENT_INSTALATION_SP_DESCRIPTOR;
    }
}

