/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.services.validation.Validation;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class BlankAttributeValidator
implements SimpleValidator {
    public static final String ID = "up-blank-attribute-value";
    public static final String CFG_ERROR_MESSAGE = "error-message";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        if (values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (value != null && Validation.isBlank(value)) {
            context.addError(new ValidationError(ID, inputHint, config.getStringOrDefault(CFG_ERROR_MESSAGE, "error-user-attribute-required")));
        }
        return context;
    }

    public static ValidatorConfig createConfig(String errorMessage) {
        if (errorMessage != null) {
            return ValidatorConfig.builder().config(CFG_ERROR_MESSAGE, (Object)errorMessage).build();
        }
        return ValidatorConfig.EMPTY;
    }
}

