/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderDataMarshaller;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.util.JsonSerialization;

public class SerializedBrokeredIdentityContext
implements UpdateProfileContext {
    private String id;
    private String brokerUsername;
    private String brokerSessionId;
    private String brokerUserId;
    private String code;
    private String token;
    @JsonIgnore
    private boolean emailAsUsername;
    private String identityProviderId;
    private Map<String, ContextDataEntry> contextData = new HashMap<String, ContextDataEntry>();

    @Override
    @JsonIgnore
    public boolean isEditUsernameAllowed() {
        return !this.emailAsUsername;
    }

    @Override
    @JsonIgnore
    public UserProfileContext getUserProfileContext() {
        return UserProfileContext.IDP_REVIEW;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.getFirstAttribute("username");
    }

    @Override
    public void setUsername(String username) {
        this.setSingleAttribute("username", username);
    }

    public String getModelUsername() {
        return this.getFirstAttribute("username");
    }

    public void setModelUsername(String modelUsername) {
        this.setSingleAttribute("username", modelUsername);
    }

    public String getBrokerUsername() {
        return this.brokerUsername;
    }

    public void setBrokerUsername(String modelUsername) {
        this.brokerUsername = modelUsername;
    }

    @Override
    public String getEmail() {
        return this.getFirstAttribute("email");
    }

    @Override
    public void setEmail(String email) {
        this.setSingleAttribute("email", email);
    }

    @Override
    public String getFirstName() {
        return this.getFirstAttribute("firstName");
    }

    @Override
    public void setFirstName(String firstName) {
        this.setSingleAttribute("firstName", firstName);
    }

    @Override
    public String getLastName() {
        return this.getFirstAttribute("lastName");
    }

    @Override
    public void setLastName(String lastName) {
        this.setSingleAttribute("lastName", lastName);
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public void setIdentityProviderId(String identityProviderId) {
        this.identityProviderId = identityProviderId;
    }

    public Map<String, ContextDataEntry> getContextData() {
        return this.contextData;
    }

    public void setContextData(Map<String, ContextDataEntry> contextData) {
        this.contextData = contextData;
    }

    @Override
    @JsonIgnore
    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, ContextDataEntry> entry : this.contextData.entrySet()) {
            if (!entry.getKey().startsWith("user.attributes.")) continue;
            String attrName = entry.getKey().substring(16);
            List<String> asList = this.getAttribute(attrName);
            result.put(attrName, asList);
        }
        return result;
    }

    @Override
    @JsonIgnore
    public void setSingleAttribute(String name, String value) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setAttribute(name, list);
    }

    @Override
    @JsonIgnore
    public void setAttribute(String key, List<String> value) {
        try {
            byte[] listBytes = JsonSerialization.writeValueAsBytes(value);
            String listStr = Base64Url.encode((byte[])listBytes);
            ContextDataEntry ctxEntry = ContextDataEntry.create(List.class.getName(), listStr);
            this.contextData.put("user.attributes." + key, ctxEntry);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    @JsonIgnore
    public List<String> getAttribute(String key) {
        return this.getAttributeStream(key).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public Stream<String> getAttributeStream(String key) {
        ContextDataEntry ctxEntry = this.contextData.get("user.attributes." + key);
        if (ctxEntry != null) {
            try {
                String asString = ctxEntry.getData();
                byte[] asBytes = Base64Url.decode((String)asString);
                return ((List)JsonSerialization.readValue((byte[])asBytes, List.class)).stream();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return Stream.empty();
    }

    @Override
    @JsonIgnore
    public String getFirstAttribute(String name) {
        List<String> attrs = this.getAttribute(name);
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs.get(0);
    }

    public BrokeredIdentityContext deserialize(KeycloakSession session, AuthenticationSessionModel authSession) {
        BrokeredIdentityContext ctx = new BrokeredIdentityContext(this.getId());
        ctx.setUsername(this.getBrokerUsername());
        ctx.setModelUsername(this.getModelUsername());
        ctx.setEmail(this.getEmail());
        ctx.setFirstName(this.getFirstName());
        ctx.setLastName(this.getLastName());
        ctx.setBrokerSessionId(this.getBrokerSessionId());
        ctx.setBrokerUserId(this.getBrokerUserId());
        ctx.setToken(this.getToken());
        RealmModel realm = authSession.getRealm();
        IdentityProviderModel idpConfig = realm.getIdentityProviderByAlias(this.getIdentityProviderId());
        if (idpConfig == null) {
            throw new ModelException("Can't find identity provider with ID " + this.getIdentityProviderId() + " in realm " + realm.getName());
        }
        IdentityProvider idp = IdentityBrokerService.getIdentityProvider(session, realm, idpConfig.getAlias());
        ctx.setIdpConfig(idpConfig);
        ctx.setIdp(idp);
        IdentityProviderDataMarshaller serializer = idp.getMarshaller();
        for (Map.Entry<String, ContextDataEntry> entry : this.getContextData().entrySet()) {
            try {
                ContextDataEntry value = entry.getValue();
                Class clazz = Reflections.classForName((String)value.getClazz(), (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
                Object deserialized = serializer.deserialize(value.getData(), clazz);
                ctx.getContextData().put(entry.getKey(), deserialized);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ctx.setAuthenticationSession(authSession);
        return ctx;
    }

    public static SerializedBrokeredIdentityContext serialize(BrokeredIdentityContext context) {
        SerializedBrokeredIdentityContext ctx = new SerializedBrokeredIdentityContext();
        ctx.setId(context.getId());
        ctx.setBrokerUsername(context.getUsername());
        ctx.setModelUsername(context.getModelUsername());
        ctx.setEmail(context.getEmail());
        ctx.setFirstName(context.getFirstName());
        ctx.setLastName(context.getLastName());
        ctx.setBrokerSessionId(context.getBrokerSessionId());
        ctx.setBrokerUserId(context.getBrokerUserId());
        ctx.setToken(context.getToken());
        ctx.setIdentityProviderId(context.getIdpConfig().getAlias());
        ctx.emailAsUsername = context.getAuthenticationSession().getRealm().isRegistrationEmailAsUsername();
        IdentityProviderDataMarshaller serializer = context.getIdp().getMarshaller();
        for (Map.Entry entry : context.getContextData().entrySet()) {
            Object value = entry.getValue();
            String serializedValue = serializer.serialize(value);
            ContextDataEntry ctxEntry = ContextDataEntry.create(value.getClass().getName(), serializedValue);
            ctx.getContextData().put((String)entry.getKey(), ctxEntry);
        }
        return ctx;
    }

    public void saveToAuthenticationSession(AuthenticationSessionModel authSession, String noteKey) {
        try {
            String asString = JsonSerialization.writeValueAsString((Object)this);
            authSession.setAuthNote(noteKey, asString);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static SerializedBrokeredIdentityContext readFromAuthenticationSession(AuthenticationSessionModel authSession, String noteKey) {
        String asString = authSession.getAuthNote(noteKey);
        if (asString == null) {
            return null;
        }
        try {
            SerializedBrokeredIdentityContext serializedCtx = (SerializedBrokeredIdentityContext)JsonSerialization.readValue((String)asString, SerializedBrokeredIdentityContext.class);
            serializedCtx.emailAsUsername = authSession.getRealm().isRegistrationEmailAsUsername();
            return serializedCtx;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static class ContextDataEntry {
        private String clazz;
        private String data;

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public static ContextDataEntry create(String clazz, String data) {
            ContextDataEntry entry = new ContextDataEntry();
            entry.setClazz(clazz);
            entry.setData(data);
            return entry;
        }
    }
}

