/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.credential.dto.OTPCredentialData;
import org.keycloak.models.credential.dto.OTPSecretData;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;

public class OTPCredentialProvider
implements CredentialProvider<OTPCredentialModel>,
CredentialInputValidator {
    private static final Logger logger = Logger.getLogger(OTPCredentialProvider.class);
    protected KeycloakSession session;

    private UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public OTPCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, OTPCredentialModel credentialModel) {
        if (credentialModel.getCreatedDate() == null) {
            credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        }
        return this.getCredentialStore().createCredential(realm, user, (CredentialModel)credentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return this.getCredentialStore().removeStoredCredential(realm, user, credentialId);
    }

    public OTPCredentialModel getCredentialFromModel(CredentialModel model) {
        return OTPCredentialModel.createFromCredentialModel((CredentialModel)model);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return this.getCredentialStore().getStoredCredentialsByTypeStream(realm, user, credentialType).count() > 0L;
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user) {
        return this.isConfiguredFor(realm, user, this.getType());
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput credentialInput) {
        if (!(credentialInput instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        String challengeResponse = credentialInput.getChallengeResponse();
        if (challengeResponse == null) {
            return false;
        }
        if (ObjectUtil.isBlank((CharSequence)credentialInput.getCredentialId())) {
            logger.debugf("CredentialId is null when validating credential of user %s", (Object)user.getUsername());
            return false;
        }
        CredentialModel credential = this.getCredentialStore().getStoredCredentialById(realm, user, credentialInput.getCredentialId());
        OTPCredentialModel otpCredentialModel = OTPCredentialModel.createFromCredentialModel((CredentialModel)credential);
        OTPSecretData secretData = otpCredentialModel.getOTPSecretData();
        OTPCredentialData credentialData = otpCredentialModel.getOTPCredentialData();
        OTPPolicy policy = realm.getOTPPolicy();
        if ("hotp".equals(credentialData.getSubType())) {
            HmacOTP validator = new HmacOTP(credentialData.getDigits(), credentialData.getAlgorithm(), policy.getLookAheadWindow());
            int counter = validator.validateHOTP(challengeResponse, secretData.getValue(), credentialData.getCounter());
            if (counter < 0) {
                return false;
            }
            otpCredentialModel.updateCounter(counter);
            this.getCredentialStore().updateCredential(realm, user, (CredentialModel)otpCredentialModel);
            return true;
        }
        if ("totp".equals(credentialData.getSubType())) {
            TimeBasedOTP validator = new TimeBasedOTP(credentialData.getAlgorithm(), credentialData.getDigits(), credentialData.getPeriod(), policy.getLookAheadWindow());
            return validator.validateTOTP(challengeResponse, secretData.getValue().getBytes(StandardCharsets.UTF_8));
        }
        return false;
    }

    public String getType() {
        return "otp";
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("otp-display-name").helpText("otp-help-text").iconCssClass("kcAuthenticatorOTPClass").createAction(UserModel.RequiredAction.CONFIGURE_TOTP.toString()).removeable(true).build(this.session);
    }
}

