/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class AttackDetectionResource {
    protected static final Logger logger = Logger.getLogger(AttackDetectionResource.class);
    protected AdminPermissionEvaluator auth;
    protected RealmModel realm;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection connection;
    @Context
    protected HttpHeaders headers;

    public AttackDetectionResource(AdminPermissionEvaluator auth, RealmModel realm, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.realm(realm).resource(ResourceType.USER_LOGIN_FAILURE);
    }

    @GET
    @Path(value="brute-force/users/{userId}")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Object> bruteForceUserStatus(@PathParam(value="userId") String userId) {
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user == null) {
            this.auth.users().requireView();
        } else {
            this.auth.users().requireView(user);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("disabled", false);
        data.put("numFailures", 0);
        data.put("lastFailure", 0);
        data.put("lastIPFailure", "n/a");
        if (!this.realm.isBruteForceProtected()) {
            return data;
        }
        UserLoginFailureModel model = this.session.loginFailures().getUserLoginFailure(this.realm, userId);
        if (model == null) {
            return data;
        }
        boolean disabled = user == null ? Time.currentTime() < model.getFailedLoginNotBefore() : ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, user);
        if (disabled) {
            data.put("disabled", true);
        }
        data.put("numFailures", model.getNumFailures());
        data.put("lastFailure", model.getLastFailure());
        data.put("lastIPFailure", model.getLastIPFailure());
        return data;
    }

    @Path(value="brute-force/users/{userId}")
    @DELETE
    public void clearBruteForceForUser(@PathParam(value="userId") String userId) {
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user == null) {
            this.auth.users().requireManage();
        } else {
            this.auth.users().requireManage(user);
        }
        UserLoginFailureModel model = this.session.loginFailures().getUserLoginFailure(this.realm, userId);
        if (model != null) {
            this.session.loginFailures().removeUserLoginFailure(this.realm, userId);
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        }
    }

    @Path(value="brute-force/users")
    @DELETE
    public void clearAllBruteForce() {
        this.auth.users().requireManage();
        this.session.loginFailures().removeAllUserLoginFailures(this.realm);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }
}

