/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.truststore.FileTruststoreProvider;
import org.keycloak.truststore.HostnameVerificationPolicy;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;
import org.keycloak.truststore.TruststoreProviderSingleton;

public class FileTruststoreProviderFactory
implements TruststoreProviderFactory {
    private static final Logger log = Logger.getLogger(FileTruststoreProviderFactory.class);
    private TruststoreProvider provider;

    public TruststoreProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void init(Config.Scope config) {
        String storepath = config.get("file");
        String pass = config.get("password");
        String policy = config.get("hostname-verification-policy");
        if (storepath == null && pass == null && policy == null) {
            return;
        }
        HostnameVerificationPolicy verificationPolicy = null;
        KeyStore truststore = null;
        if (storepath == null) {
            throw new RuntimeException("Attribute 'file' missing in 'truststore':'file' configuration");
        }
        if (pass == null) {
            throw new RuntimeException("Attribute 'password' missing in 'truststore':'file' configuration");
        }
        try {
            truststore = this.loadStore(storepath, pass == null ? null : pass.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize TruststoreProviderFactory: " + new File(storepath).getAbsolutePath(), e);
        }
        if (policy == null) {
            verificationPolicy = HostnameVerificationPolicy.WILDCARD;
        } else {
            try {
                verificationPolicy = HostnameVerificationPolicy.valueOf((String)policy);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid value for 'hostname-verification-policy': " + policy + " (must be one of: ANY, WILDCARD, STRICT)");
            }
        }
        TruststoreCertificatesLoader certsLoader = new TruststoreCertificatesLoader(truststore);
        this.provider = new FileTruststoreProvider(truststore, verificationPolicy, Collections.unmodifiableMap(certsLoader.trustedRootCerts), Collections.unmodifiableMap(certsLoader.intermediateCerts));
        TruststoreProviderSingleton.set(this.provider);
        log.debug((Object)("File truststore provider initialized: " + new File(storepath).getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadStore(String path, char[] password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream is = new FileInputStream(path);
        try {
            ks.load(is, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "file";
    }

    private static class TruststoreCertificatesLoader {
        private Map<X500Principal, X509Certificate> trustedRootCerts = new HashMap<X500Principal, X509Certificate>();
        private Map<X500Principal, X509Certificate> intermediateCerts = new HashMap<X500Principal, X509Certificate>();

        public TruststoreCertificatesLoader(KeyStore truststore) {
            this.readTruststore(truststore);
        }

        private void readTruststore(KeyStore truststore) {
            try {
                Enumeration<String> enumeration = truststore.aliases();
                log.trace((Object)("Checking " + truststore.size() + " entries from the truststore."));
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    Certificate certificate = truststore.getCertificate(alias);
                    if (certificate instanceof X509Certificate) {
                        X500Principal principal;
                        X509Certificate cax509cert = (X509Certificate)certificate;
                        if (this.isSelfSigned(cax509cert)) {
                            principal = cax509cert.getSubjectX500Principal();
                            this.trustedRootCerts.put(principal, cax509cert);
                            log.debug((Object)("Trusted root CA found in trustore : alias : " + alias + " | Subject DN : " + principal));
                            continue;
                        }
                        principal = cax509cert.getSubjectX500Principal();
                        this.intermediateCerts.put(principal, cax509cert);
                        log.debug((Object)("Intermediate CA found in trustore : alias : " + alias + " | Subject DN : " + principal));
                        continue;
                    }
                    log.info((Object)("Skipping certificate with alias [" + alias + "] from truststore, because it's not an X509Certificate"));
                }
            }
            catch (KeyStoreException e) {
                log.error((Object)("Error while reading Keycloak truststore " + e.getMessage()), (Throwable)e);
            }
            catch (CertificateException e) {
                log.error((Object)("Error while reading Keycloak truststore " + e.getMessage()), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)("Error while reading Keycloak truststore " + e.getMessage()), (Throwable)e);
            }
            catch (NoSuchProviderException e) {
                log.error((Object)("Error while reading Keycloak truststore " + e.getMessage()), (Throwable)e);
            }
        }

        private boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
            try {
                PublicKey key = cert.getPublicKey();
                cert.verify(key);
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as root CA"));
                return true;
            }
            catch (SignatureException sigEx) {
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as intermediate CA"));
            }
            catch (InvalidKeyException keyEx) {
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as intermediate CA"));
            }
            return false;
        }
    }
}

