/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;

public class SAMLEndpoint {
    protected static final Logger logger = Logger.getLogger(SAMLEndpoint.class);
    public static final String SAML_FEDERATED_SESSION_INDEX = "SAML_FEDERATED_SESSION_INDEX";
    public static final String SAML_FEDERATED_SUBJECT = "SAML_FEDERATED_SUBJECT";
    public static final String SAML_FEDERATED_SUBJECT_NAMEFORMAT = "SAML_FEDERATED_SUBJECT_NAMEFORMAT";
    public static final String SAML_LOGIN_RESPONSE = "SAML_LOGIN_RESPONSE";
    public static final String SAML_ASSERTION = "SAML_ASSERTION";
    public static final String SAML_AUTHN_STATEMENT = "SAML_AUTHN_STATEMENT";
    protected RealmModel realm;
    protected EventBuilder event;
    protected SAMLIdentityProviderConfig config;
    protected IdentityProvider.AuthenticationCallback callback;
    protected SAMLIdentityProvider provider;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpHeaders headers;

    public SAMLEndpoint(RealmModel realm, SAMLIdentityProvider provider, SAMLIdentityProviderConfig config, IdentityProvider.AuthenticationCallback callback) {
        this.realm = realm;
        this.config = config;
        this.callback = callback;
        this.provider = provider;
    }

    @GET
    @NoCache
    @Path(value="descriptor")
    public Response getSPDescriptor() {
        return this.provider.export(this.uriInfo, this.realm, null);
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState);
    }

    protected class RedirectBinding
    extends Binding {
        protected RedirectBinding() {
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            KeyLocator locator = this.getIDPKeyLocator();
            SamlProtocolUtils.verifyRedirectSignature(documentHolder, locator, SAMLEndpoint.this.uriInfo, key);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponseRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class PostBinding
    extends Binding {
        protected PostBinding() {
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            SamlProtocolUtils.verifyDocumentSignature(documentHolder.getSamlDocument(), this.getIDPKeyLocator());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
            return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    protected abstract class Binding {
        protected Binding() {
        }

        private boolean checkSsl() {
            if (SAMLEndpoint.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SAMLEndpoint.this.realm.getSslRequired().isRequired(SAMLEndpoint.this.clientConnection);
        }

        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("ssl_required");
                return ErrorPage.error(SAMLEndpoint.this.session, "httpsRequiredMessage", new Object[0]);
            }
            if (!SAMLEndpoint.this.realm.isEnabled()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN_ERROR);
                SAMLEndpoint.this.event.error("realm_disabled");
                return ErrorPage.error(SAMLEndpoint.this.session, "realmNotEnabledMessage", new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error(SAMLEndpoint.this.session, "invalidRequestMessage", new Object[0]);
            }
            return null;
        }

        protected abstract String getBindingType();

        protected abstract void verifySignature(String var1, SAMLDocumentHolder var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected KeyLocator getIDPKeyLocator() {
            LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
            for (String signingCertificate : SAMLEndpoint.this.config.getSigningCertificates()) {
                try {
                    X509Certificate cert = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)signingCertificate.replaceAll("\\s", ""));
                    keys.add(cert.getPublicKey());
                }
                catch (ProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new HardcodedKeyLocator(keys);
        }

        public Response execute(String samlRequest, String samlResponse, String relayState) {
            SAMLEndpoint.this.event = new EventBuilder(SAMLEndpoint.this.realm, SAMLEndpoint.this.session, SAMLEndpoint.this.clientConnection);
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState);
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder holder = this.extractRequestDocument(samlRequest);
            RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
            if (requestAbstractType.getDestination() != null && !SAMLEndpoint.this.uriInfo.getAbsolutePath().equals(requestAbstractType.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, "invalidRequestMessage", new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLRequest", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error(SAMLEndpoint.this.session, "invalidRequesterMessage", new Object[0]);
                }
            }
            if (requestAbstractType instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
                return this.logoutRequest(logout, relayState);
            }
            SAMLEndpoint.this.event.event(EventType.LOGIN);
            SAMLEndpoint.this.event.error("invalid_token");
            return ErrorPage.error(SAMLEndpoint.this.session, "invalidRequestMessage", new Object[0]);
        }

        protected Response logoutRequest(LogoutRequestType request, String relayState) {
            String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + request.getNameID().getValue();
            if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
                List userSessions = SAMLEndpoint.this.session.sessions().getUserSessionByBrokerUserId(SAMLEndpoint.this.realm, brokerUserId);
                Iterator iterator = userSessions.iterator();
                while (iterator.hasNext()) {
                    UserSessionModel userSession = (UserSessionModel)iterator.next();
                    if (userSession.getState() == UserSessionModel.State.LOGGING_OUT || userSession.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    try {
                        AuthenticationManager.backchannelLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession, SAMLEndpoint.this.uriInfo, SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers, false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            } else {
                for (String sessionIndex : request.getSessionIndex()) {
                    String brokerSessionId = brokerUserId + "." + sessionIndex;
                    UserSessionModel userSession = SAMLEndpoint.this.session.sessions().getUserSessionByBrokerSessionId(SAMLEndpoint.this.realm, brokerSessionId);
                    if (userSession == null || userSession.getState() == UserSessionModel.State.LOGGING_OUT || userSession.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    try {
                        AuthenticationManager.backchannelLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession, SAMLEndpoint.this.uriInfo, SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers, false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            }
            String issuerURL = this.getEntityId(SAMLEndpoint.this.uriInfo, SAMLEndpoint.this.realm);
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(request.getID());
            builder.destination(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            builder.issuer(issuerURL);
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder().relayState(relayState);
            boolean postBinding = SAMLEndpoint.this.config.isPostBindingResponse();
            if (SAMLEndpoint.this.config.isWantAuthnRequestsSigned()) {
                KeyManager.ActiveKey keys = SAMLEndpoint.this.session.keys().getActiveKey(SAMLEndpoint.this.realm);
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keys.getKid(), keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(SAMLEndpoint.this.provider.getSignatureAlgorithm())).signDocument();
                if (!postBinding && SAMLEndpoint.this.config.isAddExtensionsElementWithKeyInfo()) {
                    builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keys.getKid()));
                }
            }
            try {
                if (postBinding) {
                    return binding.postBinding(builder.buildDocument()).response(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
                }
                return binding.redirectBinding(builder.buildDocument()).response(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String getEntityId(UriInfo uriInfo, RealmModel realm) {
            return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
        }

        protected Response handleLoginResponse(String samlResponse, SAMLDocumentHolder holder, ResponseType responseType, String relayState) {
            try {
                KeyManager.ActiveKey keys = SAMLEndpoint.this.session.keys().getActiveKey(SAMLEndpoint.this.realm);
                AssertionType assertion = AssertionUtil.getAssertion((ResponseType)responseType, (PrivateKey)keys.getPrivateKey());
                SubjectType subject = assertion.getSubject();
                SubjectType.STSubType subType = subject.getSubType();
                NameIDType subjectNameID = (NameIDType)subType.getBaseID();
                BrokeredIdentityContext identity = new BrokeredIdentityContext(subjectNameID.getValue());
                identity.getContextData().put(SAMLEndpoint.SAML_LOGIN_RESPONSE, responseType);
                identity.getContextData().put(SAMLEndpoint.SAML_ASSERTION, assertion);
                identity.setUsername(subjectNameID.getValue());
                if (subjectNameID.getFormat() != null && subjectNameID.getFormat().toString().equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
                    identity.setEmail(subjectNameID.getValue());
                }
                if (SAMLEndpoint.this.config.isStoreToken()) {
                    identity.setToken(samlResponse);
                }
                AuthnStatementType authn = null;
                for (Object statement : assertion.getStatements()) {
                    if (!(statement instanceof AuthnStatementType)) continue;
                    authn = (AuthnStatementType)statement;
                    identity.getContextData().put(SAMLEndpoint.SAML_AUTHN_STATEMENT, authn);
                    break;
                }
                if (assertion.getAttributeStatements() != null) {
                    for (AttributeStatementType attrStatement : assertion.getAttributeStatements()) {
                        for (AttributeStatementType.ASTChoiceType choice : attrStatement.getAttributes()) {
                            AttributeType attribute = choice.getAttribute();
                            if (!X500SAMLProfileConstants.EMAIL.getFriendlyName().equals(attribute.getFriendlyName()) && !X500SAMLProfileConstants.EMAIL.get().equals(attribute.getName()) || attribute.getAttributeValue().isEmpty()) continue;
                            identity.setEmail(attribute.getAttributeValue().get(0).toString());
                        }
                    }
                }
                String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + subjectNameID.getValue();
                identity.setBrokerUserId(brokerUserId);
                identity.setIdpConfig((IdentityProviderModel)SAMLEndpoint.this.config);
                identity.setIdp((IdentityProvider)SAMLEndpoint.this.provider);
                if (authn != null && authn.getSessionIndex() != null) {
                    identity.setBrokerSessionId(identity.getBrokerUserId() + "." + authn.getSessionIndex());
                }
                identity.setCode(relayState);
                return SAMLEndpoint.this.callback.authenticated(identity);
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not process response from SAML identity provider.", (Throwable)e);
            }
        }

        public Response handleSamlResponse(String samlResponse, String relayState) {
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (statusResponse.getDestination() != null && !SAMLEndpoint.this.uriInfo.getAbsolutePath().toString().equals(statusResponse.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, "invalidFederatedIdentityActionMessage", new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLResponse", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error(SAMLEndpoint.this.session, "invalidFederatedIdentityActionMessage", new Object[0]);
                }
            }
            if (statusResponse instanceof ResponseType) {
                return this.handleLoginResponse(samlResponse, holder, (ResponseType)statusResponse, relayState);
            }
            return this.handleLogoutResponse(holder, statusResponse, relayState);
        }

        protected Response handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
            if (relayState == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            UserSessionModel userSession = SAMLEndpoint.this.session.sessions().getUserSession(SAMLEndpoint.this.realm, relayState);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, "sessionNotActiveMessage", new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession, SAMLEndpoint.this.uriInfo, SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers);
        }
    }
}

