/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.AbstractRsaKeyProvider;
import org.keycloak.models.RealmModel;

public class RsaKeyProvider
extends AbstractRsaKeyProvider {
    public RsaKeyProvider(RealmModel realm, ComponentModel model) {
        super(realm, model);
    }

    @Override
    public AbstractRsaKeyProvider.Keys loadKeys(RealmModel realm, ComponentModel model) {
        String privateRsaKeyPem = (String)model.getConfig().getFirst((Object)"privateKey");
        String certificatePem = (String)model.getConfig().getFirst((Object)"certificate");
        PrivateKey privateKey = PemUtils.decodePrivateKey((String)privateRsaKeyPem);
        PublicKey publicKey = KeyUtils.extractPublicKey((PrivateKey)privateKey);
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        X509Certificate certificate = PemUtils.decodeCertificate((String)certificatePem);
        String kid = KeyUtils.createKeyId((Key)keyPair.getPublic());
        return new AbstractRsaKeyProvider.Keys(kid, keyPair, certificate);
    }
}

