/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayDeque;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.representations.IDToken;

abstract class AbstractUserRoleMappingMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper {
    AbstractUserRoleMappingMapper() {
    }

    public static Stream<RoleModel> getAllUserRolesStream(UserModel user) {
        return Stream.concat(user.getRoleMappings().stream(), user.getGroups().stream().flatMap(g -> AbstractUserRoleMappingMapper.groupAndItsParentsStream(g)).flatMap(g -> g.getRoleMappings().stream())).flatMap(role -> AbstractUserRoleMappingMapper.expandCompositeRolesStream(role));
    }

    private static Stream<GroupModel> groupAndItsParentsStream(GroupModel group) {
        Stream.Builder<GroupModel> sb = Stream.builder();
        while (group != null) {
            sb.add(group);
            group = group.getParent();
        }
        return sb.build();
    }

    private static Stream<RoleModel> expandCompositeRolesStream(RoleModel role) {
        Stream.Builder<RoleModel> sb = Stream.builder();
        ArrayDeque<RoleModel> stack = new ArrayDeque<RoleModel>();
        stack.add(role);
        while (!stack.isEmpty()) {
            RoleModel current = (RoleModel)stack.pop();
            sb.add(current);
            if (!current.isComposite()) continue;
            stack.addAll(current.getComposites());
        }
        return sb.build();
    }

    protected static void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, Predicate<RoleModel> restriction, String prefix) {
        String rolePrefix = prefix == null ? "" : prefix;
        UserModel user = userSession.getUser();
        Stream<RoleModel> clientUserRoles = AbstractUserRoleMappingMapper.getAllUserRolesStream(user).filter(restriction);
        boolean dontLimitScope = userSession.getClientSessions().stream().anyMatch(cs -> cs.getClient().isFullScopeAllowed());
        if (!dontLimitScope) {
            Set clientRoles = userSession.getClientSessions().stream().flatMap(cs -> cs.getClient().getScopeMappings().stream()).collect(Collectors.toSet());
            clientUserRoles = clientUserRoles.filter(clientRoles::contains);
        }
        Set realmRoleNames = clientUserRoles.map(m -> rolePrefix + m.getName()).collect(Collectors.toSet());
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, realmRoleNames);
    }
}

