/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AddressClaimSet;
import org.keycloak.representations.IDToken;

public class AddressMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-address-mapper";

    public static ProtocolMapperModel createAddressMapper() {
        ProtocolMapperModel address = new ProtocolMapperModel();
        address.setName("address");
        address.setProtocolMapper(PROVIDER_ID);
        address.setProtocol("openid-connect");
        address.setConsentRequired(true);
        address.setConsentText("${address}");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", "true");
        config.put("id.token.claim", "true");
        address.setConfig(config);
        return address;
    }

    public static ProtocolMapperModel createAddressMapper(boolean idToken, boolean accessToken) {
        ProtocolMapperModel address = new ProtocolMapperModel();
        address.setName("address");
        address.setProtocolMapper(PROVIDER_ID);
        address.setProtocol("openid-connect");
        address.setConsentRequired(true);
        address.setConsentText("${address}");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", Boolean.toString(idToken));
        config.put("id.token.claim", Boolean.toString(accessToken));
        address.setConfig(config);
        return address;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Address";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Maps user address attributes (street, locality, region, postal_code, and country) to the OpenID Connect 'address' claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        AddressClaimSet addressSet = new AddressClaimSet();
        addressSet.setStreetAddress(user.getFirstAttribute("street"));
        addressSet.setLocality(user.getFirstAttribute("locality"));
        addressSet.setRegion(user.getFirstAttribute("region"));
        addressSet.setPostalCode(user.getFirstAttribute("postal_code"));
        addressSet.setCountry(user.getFirstAttribute("country"));
        token.getOtherClaims().put("address", addressSet);
    }

    static {
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, AddressMapper.class);
    }
}

