/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.Permission;

public final class Permissions {
    public static List<ResourcePermission> all(ResourceServer resourceServer, Identity identity, AuthorizationProvider authorization) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        resourceStore.findByOwner(resourceServer.getClientId(), resourceServer.getId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissionsWithScopes(resource, resource.getScopes(), authorization)));
        resourceStore.findByOwner(identity.getId(), resourceServer.getId()).stream().forEach(resource -> permissions.addAll(Permissions.createResourcePermissionsWithScopes(resource, resource.getScopes(), authorization)));
        return permissions;
    }

    public static List<ResourcePermission> createResourcePermissions(Resource resource, Set<String> requestedScopes, AuthorizationProvider authorization) {
        List scopes;
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        String type = resource.getType();
        ResourceServer resourceServer = resource.getResourceServer();
        if (requestedScopes.isEmpty()) {
            scopes = resource.getScopes();
            if (type != null && !resource.getOwner().equals(resourceServer.getClientId())) {
                StoreFactory storeFactory = authorization.getStoreFactory();
                ResourceStore resourceStore = storeFactory.getResourceStore();
                resourceStore.findByType(type, resourceServer.getId()).forEach(resource1 -> {
                    if (resource1.getOwner().equals(resourceServer.getClientId())) {
                        for (Scope typeScope : resource1.getScopes()) {
                            if (scopes.contains(typeScope)) continue;
                            scopes.add(typeScope);
                        }
                    }
                });
            }
        } else {
            ScopeStore scopeStore = authorization.getStoreFactory().getScopeStore();
            scopes = requestedScopes.stream().map(scopeName -> {
                Scope byName = scopeStore.findByName(scopeName, resource.getResourceServer().getId());
                if (byName == null) {
                    throw new RuntimeException("Invalid scope [" + scopeName + "].");
                }
                return byName;
            }).collect(Collectors.toList());
        }
        permissions.add(new ResourcePermission(resource, scopes, resource.getResourceServer()));
        return permissions;
    }

    public static List<ResourcePermission> createResourcePermissionsWithScopes(Resource resource, List<Scope> scopes, AuthorizationProvider authorization) {
        ArrayList<ResourcePermission> permissions = new ArrayList<ResourcePermission>();
        String type = resource.getType();
        ResourceServer resourceServer = resource.getResourceServer();
        if (type != null && !resource.getOwner().equals(resourceServer.getClientId())) {
            StoreFactory storeFactory = authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            resourceStore.findByType(type, resourceServer.getId()).forEach(resource1 -> {
                if (resource1.getOwner().equals(resourceServer.getClientId())) {
                    for (Scope typeScope : resource1.getScopes()) {
                        if (scopes.contains(typeScope)) continue;
                        scopes.add(typeScope);
                    }
                }
            });
        }
        permissions.add(new ResourcePermission(resource, scopes, resource.getResourceServer()));
        return permissions;
    }

    public static List<Permission> allPermits(List<Result> evaluation, AuthorizationProvider authorizationProvider, ResourceServer resourceServer) {
        HashMap<String, Permission> permissions = new HashMap<String, Permission>();
        for (Result evaluationResult : evaluation) {
            ResourcePermission permission = evaluationResult.getPermission();
            if (evaluationResult.getEffect().equals((Object)Decision.Effect.DENY)) {
                for (Result.PolicyResult result : evaluationResult.getResults()) {
                    Policy policy = result.getPolicy();
                    if (!"scope".equals(policy.getType())) continue;
                    Set resources = policy.getResources();
                    if (!Decision.Effect.PERMIT.equals((Object)result.getStatus())) continue;
                    List scopes = policy.getScopes().stream().collect(Collectors.toList());
                    if (!resources.isEmpty()) {
                        resources.forEach(resource -> Permissions.grantPermission(authorizationProvider, permissions, new ResourcePermission(resource, scopes, policy.getResourceServer()), resourceServer.getId()));
                        continue;
                    }
                    Permissions.grantPermission(authorizationProvider, permissions, new ResourcePermission(permission.getResource(), scopes, policy.getResourceServer()), resourceServer.getId());
                }
                continue;
            }
            Permissions.grantPermission(authorizationProvider, permissions, permission, resourceServer.getId());
        }
        return permissions.values().stream().collect(Collectors.toList());
    }

    public static List<Permission> permits(List<Result> evaluation, AuthorizationProvider authorizationProvider, String resourceServer) {
        HashMap<String, Permission> permissions = new HashMap<String, Permission>();
        for (Result evaluationResult : evaluation) {
            ResourcePermission permission = evaluationResult.getPermission();
            if (evaluationResult.getEffect().equals((Object)Decision.Effect.DENY)) continue;
            Permissions.grantPermission(authorizationProvider, permissions, permission, resourceServer);
        }
        return permissions.values().stream().collect(Collectors.toList());
    }

    private static void grantPermission(AuthorizationProvider authorizationProvider, Map<String, Permission> permissions, ResourcePermission permission, String resourceServer) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = permission.getResource();
        Set scopes = permission.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
        if (resource != null) {
            resources.add(resource);
        } else {
            List permissionScopes = permission.getScopes();
            if (!permissionScopes.isEmpty()) {
                ResourceStore resourceStore = authorizationProvider.getStoreFactory().getResourceStore();
                resources.addAll(resourceStore.findByScope(permissionScopes.stream().map(Scope::getId).collect(Collectors.toList()), resourceServer));
            }
        }
        if (!resources.isEmpty()) {
            for (Resource allowedResource : resources) {
                String resourceId = allowedResource.getId();
                String resourceName = allowedResource.getName();
                Permission evalPermission = permissions.get(allowedResource.getId());
                if (evalPermission == null) {
                    evalPermission = new Permission(resourceId, resourceName, scopes);
                    permissions.put(resourceId, evalPermission);
                }
                if (scopes == null || scopes.isEmpty()) continue;
                HashSet<String> finalScopes = evalPermission.getScopes();
                if (finalScopes == null) {
                    finalScopes = new HashSet<String>();
                    evalPermission.setScopes(finalScopes);
                }
                for (String scopeName : scopes) {
                    if (finalScopes.contains(scopeName)) continue;
                    finalScopes.add(scopeName);
                }
            }
        } else {
            Permission scopePermission = new Permission(null, null, scopes);
            permissions.put(scopePermission.toString(), scopePermission);
        }
    }
}

