/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import org.keycloak.models.IdentityProviderModel;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;

public class SAMLIdentityProviderConfig
extends IdentityProviderModel {
    public static final XmlKeyInfoKeyNameTransformer DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER = XmlKeyInfoKeyNameTransformer.NONE;
    public static final String SIGNING_CERTIFICATE_KEY = "signingCertificate";

    public SAMLIdentityProviderConfig() {
    }

    public SAMLIdentityProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
    }

    public String getSingleSignOnServiceUrl() {
        return (String)this.getConfig().get("singleSignOnServiceUrl");
    }

    public void setSingleSignOnServiceUrl(String singleSignOnServiceUrl) {
        this.getConfig().put("singleSignOnServiceUrl", singleSignOnServiceUrl);
    }

    public String getSingleLogoutServiceUrl() {
        return (String)this.getConfig().get("singleLogoutServiceUrl");
    }

    public void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.getConfig().put("singleLogoutServiceUrl", singleLogoutServiceUrl);
    }

    public boolean isValidateSignature() {
        return Boolean.valueOf((String)this.getConfig().get("validateSignature"));
    }

    public void setValidateSignature(boolean validateSignature) {
        this.getConfig().put("validateSignature", String.valueOf(validateSignature));
    }

    public boolean isForceAuthn() {
        return Boolean.valueOf((String)this.getConfig().get("forceAuthn"));
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.getConfig().put("forceAuthn", String.valueOf(forceAuthn));
    }

    public String getSigningCertificate() {
        return (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
    }

    public void setSigningCertificate(String signingCertificate) {
        this.getConfig().put(SIGNING_CERTIFICATE_KEY, signingCertificate);
    }

    public void addSigningCertificate(String signingCertificate) {
        String crt = (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
        if (crt == null || crt.isEmpty()) {
            this.getConfig().put(SIGNING_CERTIFICATE_KEY, signingCertificate);
        } else {
            this.getConfig().put(SIGNING_CERTIFICATE_KEY, crt + "," + signingCertificate);
        }
    }

    public String[] getSigningCertificates() {
        String crt = (String)this.getConfig().get(SIGNING_CERTIFICATE_KEY);
        if (crt == null || crt.isEmpty()) {
            return new String[0];
        }
        return crt.split(",");
    }

    public String getNameIDPolicyFormat() {
        return (String)this.getConfig().get("nameIDPolicyFormat");
    }

    public void setNameIDPolicyFormat(String nameIDPolicyFormat) {
        this.getConfig().put("nameIDPolicyFormat", nameIDPolicyFormat);
    }

    public boolean isWantAuthnRequestsSigned() {
        return Boolean.valueOf((String)this.getConfig().get("wantAuthnRequestsSigned"));
    }

    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.getConfig().put("wantAuthnRequestsSigned", String.valueOf(wantAuthnRequestsSigned));
    }

    public boolean isAddExtensionsElementWithKeyInfo() {
        return Boolean.valueOf((String)this.getConfig().get("addExtensionsElementWithKeyInfo"));
    }

    public void setAddExtensionsElementWithKeyInfo(boolean addExtensionsElementWithKeyInfo) {
        this.getConfig().put("addExtensionsElementWithKeyInfo", String.valueOf(addExtensionsElementWithKeyInfo));
    }

    public String getSignatureAlgorithm() {
        return (String)this.getConfig().get("signatureAlgorithm");
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.getConfig().put("signatureAlgorithm", signatureAlgorithm);
    }

    public String getEncryptionPublicKey() {
        return (String)this.getConfig().get("encryptionPublicKey");
    }

    public void setEncryptionPublicKey(String encryptionPublicKey) {
        this.getConfig().put("encryptionPublicKey", encryptionPublicKey);
    }

    public boolean isPostBindingAuthnRequest() {
        return Boolean.valueOf((String)this.getConfig().get("postBindingAuthnRequest"));
    }

    public void setPostBindingAuthnRequest(boolean postBindingAuthnRequest) {
        this.getConfig().put("postBindingAuthnRequest", String.valueOf(postBindingAuthnRequest));
    }

    public boolean isPostBindingResponse() {
        return Boolean.valueOf((String)this.getConfig().get("postBindingResponse"));
    }

    public void setPostBindingResponse(boolean postBindingResponse) {
        this.getConfig().put("postBindingResponse", String.valueOf(postBindingResponse));
    }

    public boolean isBackchannelSupported() {
        return Boolean.valueOf((String)this.getConfig().get("backchannelSupported"));
    }

    public void setBackchannelSupported(boolean backchannel) {
        this.getConfig().put("backchannelSupported", String.valueOf(backchannel));
    }

    public XmlKeyInfoKeyNameTransformer getXmlSigKeyInfoKeyNameTransformer() {
        return XmlKeyInfoKeyNameTransformer.from((String)((String)this.getConfig().get("xmlSigKeyInfoKeyNameTransformer")), (XmlKeyInfoKeyNameTransformer)DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER);
    }

    public void setXmlSigKeyInfoKeyNameTransformer(XmlKeyInfoKeyNameTransformer xmlSigKeyInfoKeyNameTransformer) {
        this.getConfig().put("xmlSigKeyInfoKeyNameTransformer", xmlSigKeyInfoKeyNameTransformer == null ? null : xmlSigKeyInfoKeyNameTransformer.name());
    }
}

