/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationProviderFactory;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.Version;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.util.JsonSerialization;

public class ExportUtils {
    public static RealmRepresentation exportRealm(KeycloakSession session, RealmModel realm, boolean includeUsers) {
        List<ScopeMappingRepresentation> currentAppScopes;
        String appName;
        ClientModel app;
        RoleModel scope;
        Iterator iterator;
        ScopeMappingRepresentation scopeMappingRep;
        Object clientScopes;
        RealmRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)realm, (boolean)true);
        rep.setKeycloakVersion(Version.VERSION);
        List templates = realm.getClientTemplates();
        ArrayList<ClientTemplateRepresentation> templateReps = new ArrayList<ClientTemplateRepresentation>();
        for (ClientTemplateModel app2 : templates) {
            ClientTemplateRepresentation clientRep = ModelToRepresentation.toRepresentation((ClientTemplateModel)app2);
            templateReps.add(clientRep);
        }
        rep.setClientTemplates(templateReps);
        List clients = realm.getClients();
        ArrayList<ClientRepresentation> clientReps = new ArrayList<ClientRepresentation>();
        for (ClientModel app3 : clients) {
            ClientRepresentation clientRep = ExportUtils.exportClient(session, app3);
            clientReps.add(clientRep);
        }
        rep.setClients(clientReps);
        List<RoleRepresentation> realmRoleReps = null;
        HashMap<String, List<RoleRepresentation>> clientRolesReps = new HashMap<String, List<RoleRepresentation>>();
        Set realmRoles = realm.getRoles();
        if (realmRoles != null && realmRoles.size() > 0) {
            realmRoleReps = ExportUtils.exportRoles(realmRoles);
        }
        for (ClientModel client : clients) {
            Set currentAppRoles = client.getRoles();
            Iterator currentAppRoleReps = ExportUtils.exportRoles(currentAppRoles);
            clientRolesReps.put(client.getClientId(), (List<RoleRepresentation>)((Object)currentAppRoleReps));
        }
        RolesRepresentation rolesRep = new RolesRepresentation();
        if (realmRoleReps != null) {
            rolesRep.setRealm(realmRoleReps);
        }
        if (clientRolesReps.size() > 0) {
            rolesRep.setClient(clientRolesReps);
        }
        rep.setRoles(rolesRep);
        ArrayList allClients = new ArrayList(clients);
        HashMap<String, List<ScopeMappingRepresentation>> clientScopeReps = new HashMap<String, List<ScopeMappingRepresentation>>();
        for (ClientModel client : allClients) {
            clientScopes = client.getScopeMappings();
            scopeMappingRep = null;
            iterator = clientScopes.iterator();
            while (iterator.hasNext()) {
                scope = (RoleModel)iterator.next();
                if (scope.getContainer() instanceof RealmModel) {
                    if (scopeMappingRep == null) {
                        scopeMappingRep = rep.clientScopeMapping(client.getClientId());
                    }
                    scopeMappingRep.role(scope.getName());
                    continue;
                }
                app = (ClientModel)scope.getContainer();
                appName = app.getClientId();
                currentAppScopes = (ArrayList)clientScopeReps.get(appName);
                if (currentAppScopes == null) {
                    currentAppScopes = new ArrayList();
                    clientScopeReps.put(appName, currentAppScopes);
                }
                ScopeMappingRepresentation currentClientScope = null;
                for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                    if (!client.getClientId().equals(scopeMapping.getClient())) continue;
                    currentClientScope = scopeMapping;
                    break;
                }
                if (currentClientScope == null) {
                    currentClientScope = new ScopeMappingRepresentation();
                    currentClientScope.setClient(client.getClientId());
                    currentAppScopes.add(currentClientScope);
                }
                currentClientScope.role(scope.getName());
            }
        }
        for (ClientTemplateModel clientTemplate : realm.getClientTemplates()) {
            clientScopes = clientTemplate.getScopeMappings();
            scopeMappingRep = null;
            iterator = clientScopes.iterator();
            while (iterator.hasNext()) {
                scope = (RoleModel)iterator.next();
                if (scope.getContainer() instanceof RealmModel) {
                    if (scopeMappingRep == null) {
                        scopeMappingRep = rep.clientTemplateScopeMapping(clientTemplate.getName());
                    }
                    scopeMappingRep.role(scope.getName());
                    continue;
                }
                app = (ClientModel)scope.getContainer();
                appName = app.getClientId();
                currentAppScopes = (List)clientScopeReps.get(appName);
                if (currentAppScopes == null) {
                    currentAppScopes = new ArrayList();
                    clientScopeReps.put(appName, currentAppScopes);
                }
                ScopeMappingRepresentation currentClientTemplateScope = null;
                for (ScopeMappingRepresentation scopeMapping : currentAppScopes) {
                    if (!clientTemplate.getName().equals(scopeMapping.getClientTemplate())) continue;
                    currentClientTemplateScope = scopeMapping;
                    break;
                }
                if (currentClientTemplateScope == null) {
                    currentClientTemplateScope = new ScopeMappingRepresentation();
                    currentClientTemplateScope.setClientTemplate(clientTemplate.getName());
                    currentAppScopes.add(currentClientTemplateScope);
                }
                currentClientTemplateScope.role(scope.getName());
            }
        }
        if (clientScopeReps.size() > 0) {
            rep.setClientScopeMappings(clientScopeReps);
        }
        if (includeUsers) {
            List allUsers = session.users().getUsers(realm, true);
            LinkedList<UserRepresentation> users = new LinkedList<UserRepresentation>();
            for (UserModel user : allUsers) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                users.add(userRep);
            }
            if (users.size() > 0) {
                rep.setUsers(users);
            }
            LinkedList<UserRepresentation> federatedUsers = new LinkedList<UserRepresentation>();
            for (String userId : session.userFederatedStorage().getStoredUsers(realm, 0, -1)) {
                UserRepresentation userRep = ExportUtils.exportFederatedUser(session, realm, userId);
                federatedUsers.add(userRep);
            }
            if (federatedUsers.size() > 0) {
                rep.setFederatedUsers(federatedUsers);
            }
        }
        MultivaluedHashMap<String, ComponentExportRepresentation> components = ExportUtils.exportComponents(realm, realm.getId());
        rep.setComponents(components);
        return rep;
    }

    public static MultivaluedHashMap<String, ComponentExportRepresentation> exportComponents(RealmModel realm, String parentId) {
        List componentList = realm.getComponents(parentId);
        MultivaluedHashMap components = new MultivaluedHashMap();
        for (ComponentModel component : componentList) {
            ComponentExportRepresentation compRep = new ComponentExportRepresentation();
            compRep.setId(component.getId());
            compRep.setProviderId(component.getProviderId());
            compRep.setConfig(component.getConfig());
            compRep.setName(component.getName());
            compRep.setSubType(component.getSubType());
            compRep.setSubComponents(ExportUtils.exportComponents(realm, component.getId()));
            components.add((Object)component.getProviderType(), (Object)compRep);
        }
        return components;
    }

    public static ClientRepresentation exportClient(KeycloakSession session, ClientModel client) {
        ClientRepresentation clientRep = ModelToRepresentation.toRepresentation((ClientModel)client);
        clientRep.setSecret(client.getSecret());
        clientRep.setAuthorizationSettings(ExportUtils.exportAuthorizationSettings(session, client));
        return clientRep;
    }

    public static ResourceServerRepresentation exportAuthorizationSettings(KeycloakSession session, ClientModel client) {
        AuthorizationProviderFactory providerFactory = (AuthorizationProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorization = providerFactory.create(session, client.getRealm());
        StoreFactory storeFactory = authorization.getStoreFactory();
        ResourceServer settingsModel = authorization.getStoreFactory().getResourceServerStore().findByClient(client.getId());
        if (settingsModel == null) {
            return null;
        }
        ResourceServerRepresentation representation = ModelToRepresentation.toRepresentation((ResourceServer)settingsModel, (ClientModel)client);
        representation.setId(null);
        representation.setName(null);
        representation.setClientId(null);
        List resources = storeFactory.getResourceStore().findByResourceServer(settingsModel.getId()).stream().map(resource -> {
            ResourceRepresentation rep = ModelToRepresentation.toRepresentation((Resource)resource, (ResourceServer)settingsModel, (AuthorizationProvider)authorization);
            if (rep.getOwner().getId().equals(settingsModel.getClientId())) {
                rep.setOwner(null);
            } else {
                rep.getOwner().setId(null);
            }
            rep.setId(null);
            rep.getScopes().forEach(scopeRepresentation -> {
                scopeRepresentation.setId(null);
                scopeRepresentation.setIconUri(null);
            });
            return rep;
        }).collect(Collectors.toList());
        representation.setResources(resources);
        ArrayList policies = new ArrayList();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        policies.addAll(policyStore.findByResourceServer(settingsModel.getId()).stream().filter(policy -> !policy.getType().equals("resource") && !policy.getType().equals("scope")).map(policy -> ExportUtils.createPolicyRepresentation(authorization, policy)).collect(Collectors.toList()));
        policies.addAll(policyStore.findByResourceServer(settingsModel.getId()).stream().filter(policy -> policy.getType().equals("resource") || policy.getType().equals("scope")).map(policy -> ExportUtils.createPolicyRepresentation(authorization, policy)).collect(Collectors.toList()));
        representation.setPolicies(policies);
        List scopes = storeFactory.getScopeStore().findByResourceServer(settingsModel.getId()).stream().map(scope -> {
            ScopeRepresentation rep = ModelToRepresentation.toRepresentation((Scope)scope, (AuthorizationProvider)authorization);
            rep.setId(null);
            rep.setPolicies(null);
            rep.setResources(null);
            return rep;
        }).collect(Collectors.toList());
        representation.setScopes(scopes);
        return representation;
    }

    private static PolicyRepresentation createPolicyRepresentation(AuthorizationProvider authorizationProvider, Policy policy) {
        KeycloakSession session = authorizationProvider.getKeycloakSession();
        RealmModel realm = authorizationProvider.getRealm();
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        try {
            Set associatedPolicies;
            Set policyResources;
            Set scopes;
            String users;
            PolicyRepresentation rep = ModelToRepresentation.toRepresentation((Policy)policy);
            rep.setId(null);
            Map config = rep.getConfig();
            String roles = (String)config.get("roles");
            if (roles != null && !roles.isEmpty()) {
                List rolesMap = (List)JsonSerialization.readValue((String)roles, List.class);
                config.put("roles", JsonSerialization.writeValueAsString(rolesMap.stream().map(roleMap -> {
                    roleMap.put("id", realm.getRoleById(roleMap.get("id").toString()).getName());
                    return roleMap;
                }).collect(Collectors.toList())));
            }
            if ((users = (String)config.get("users")) != null && !users.isEmpty()) {
                UserProvider userManager = session.users();
                List userIds = (List)JsonSerialization.readValue((String)users, List.class);
                config.put("users", JsonSerialization.writeValueAsString(userIds.stream().map(userId -> userManager.getUserById(userId, realm).getUsername()).collect(Collectors.toList())));
            }
            if (!(scopes = policy.getScopes()).isEmpty()) {
                List scopeNames = scopes.stream().map(Scope::getName).collect(Collectors.toList());
                config.put("scopes", JsonSerialization.writeValueAsString(scopeNames));
            }
            if (!(policyResources = policy.getResources()).isEmpty()) {
                List resourceNames = scopes.stream().map(Scope::getName).collect(Collectors.toList());
                config.put("resources", JsonSerialization.writeValueAsString(resourceNames));
            }
            if (!(associatedPolicies = policy.getAssociatedPolicies()).isEmpty()) {
                config.put("applyPolicies", JsonSerialization.writeValueAsString(associatedPolicies.stream().map(associated -> associated.getName()).collect(Collectors.toList())));
            }
            return rep;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while exporting policy [" + policy.getName() + "].", e);
        }
    }

    public static List<RoleRepresentation> exportRoles(Collection<RoleModel> roles) {
        ArrayList<RoleRepresentation> roleReps = new ArrayList<RoleRepresentation>();
        for (RoleModel role : roles) {
            RoleRepresentation roleRep = ExportUtils.exportRole(role);
            roleReps.add(roleRep);
        }
        return roleReps;
    }

    public static List<String> getRoleNames(Collection<RoleModel> roles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (RoleModel role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public static RoleRepresentation exportRole(RoleModel role) {
        RoleRepresentation roleRep = ModelToRepresentation.toRepresentation((RoleModel)role);
        Set composites = role.getComposites();
        if (composites != null && composites.size() > 0) {
            HashSet<String> compositeRealmRoles = null;
            HashMap<String, ArrayList<String>> compositeClientRoles = null;
            for (RoleModel composite : composites) {
                ClientModel app;
                String appName;
                ArrayList<String> currentAppComposites;
                RoleContainerModel crContainer = composite.getContainer();
                if (crContainer instanceof RealmModel) {
                    if (compositeRealmRoles == null) {
                        compositeRealmRoles = new HashSet<String>();
                    }
                    compositeRealmRoles.add(composite.getName());
                    continue;
                }
                if (compositeClientRoles == null) {
                    compositeClientRoles = new HashMap<String, ArrayList<String>>();
                }
                if ((currentAppComposites = (ArrayList<String>)compositeClientRoles.get(appName = (app = (ClientModel)crContainer).getClientId())) == null) {
                    currentAppComposites = new ArrayList<String>();
                    compositeClientRoles.put(appName, currentAppComposites);
                }
                currentAppComposites.add(composite.getName());
            }
            RoleRepresentation.Composites compRep = new RoleRepresentation.Composites();
            if (compositeRealmRoles != null) {
                compRep.setRealm(compositeRealmRoles);
            }
            if (compositeClientRoles != null) {
                compRep.setClient(compositeClientRoles);
            }
            roleRep.setComposites(compRep);
        }
        return roleRep;
    }

    public static UserRepresentation exportUser(KeycloakSession session, RealmModel realm, UserModel user) {
        String clientInternalId;
        ClientModel client;
        UserRepresentation userRep = ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)realm, (UserModel)user);
        Set socialLinks = session.users().getFederatedIdentities(user, realm);
        ArrayList<FederatedIdentityRepresentation> socialLinkReps = new ArrayList<FederatedIdentityRepresentation>();
        for (FederatedIdentityModel socialLink : socialLinks) {
            FederatedIdentityRepresentation socialLinkRep = ExportUtils.exportSocialLink(socialLink);
            socialLinkReps.add(socialLinkRep);
        }
        if (socialLinkReps.size() > 0) {
            userRep.setFederatedIdentities(socialLinkReps);
        }
        Set roles = user.getRoleMappings();
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client2 = (ClientModel)role.getContainer();
            String clientId = client2.getClientId();
            ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
            if (currentClientRoles == null) {
                currentClientRoles = new ArrayList<String>();
                clientRoleNames.put(clientId, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        if (realmRoleNames.size() > 0) {
            userRep.setRealmRoles(realmRoleNames);
        }
        if (clientRoleNames.size() > 0) {
            userRep.setClientRoles(clientRoleNames);
        }
        List creds = session.userCredentialManager().getStoredCredentials(realm, user);
        ArrayList<CredentialRepresentation> credReps = new ArrayList<CredentialRepresentation>();
        for (CredentialModel cred : creds) {
            CredentialRepresentation credRep = ExportUtils.exportCredential(cred);
            credReps.add(credRep);
        }
        userRep.setCredentials(credReps);
        userRep.setFederationLink(user.getFederationLink());
        List consents = session.users().getConsents(realm, user.getId());
        LinkedList<UserConsentRepresentation> consentReps = new LinkedList<UserConsentRepresentation>();
        for (UserConsentModel consent : consents) {
            UserConsentRepresentation consentRep = ModelToRepresentation.toRepresentation((UserConsentModel)consent);
            consentReps.add(consentRep);
        }
        if (consentReps.size() > 0) {
            userRep.setClientConsents(consentReps);
        }
        if (user.getServiceAccountClientLink() != null && (client = realm.getClientById(clientInternalId = user.getServiceAccountClientLink())) != null) {
            userRep.setServiceAccountClientId(client.getClientId());
        }
        LinkedList<String> groups = new LinkedList<String>();
        for (GroupModel group : user.getGroups()) {
            groups.add(ModelToRepresentation.buildGroupPath((GroupModel)group));
        }
        userRep.setGroups(groups);
        return userRep;
    }

    public static FederatedIdentityRepresentation exportSocialLink(FederatedIdentityModel socialLink) {
        FederatedIdentityRepresentation socialLinkRep = new FederatedIdentityRepresentation();
        socialLinkRep.setIdentityProvider(socialLink.getIdentityProvider());
        socialLinkRep.setUserId(socialLink.getUserId());
        socialLinkRep.setUserName(socialLink.getUserName());
        return socialLinkRep;
    }

    public static CredentialRepresentation exportCredential(CredentialModel userCred) {
        CredentialRepresentation credRep = new CredentialRepresentation();
        credRep.setType(userCred.getType());
        credRep.setDevice(userCred.getDevice());
        credRep.setHashedSaltedValue(userCred.getValue());
        if (userCred.getSalt() != null) {
            credRep.setSalt(Base64.encodeBytes((byte[])userCred.getSalt()));
        }
        credRep.setHashIterations(Integer.valueOf(userCred.getHashIterations()));
        credRep.setCounter(Integer.valueOf(userCred.getCounter()));
        credRep.setAlgorithm(userCred.getAlgorithm());
        credRep.setDigits(Integer.valueOf(userCred.getDigits()));
        credRep.setCreatedDate(userCred.getCreatedDate());
        credRep.setConfig(userCred.getConfig());
        credRep.setPeriod(Integer.valueOf(userCred.getPeriod()));
        return credRep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportUsersToStream(KeycloakSession session, RealmModel realm, List<UserModel> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        JsonFactory factory = mapper.getFactory();
        try (JsonGenerator generator = factory.createGenerator(os, JsonEncoding.UTF8);){
            if (mapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("users");
            generator.writeStartArray();
            for (UserModel user : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportUser(session, realm, user);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFederatedUsersToStream(KeycloakSession session, RealmModel realm, List<String> usersToExport, ObjectMapper mapper, OutputStream os) throws IOException {
        JsonFactory factory = mapper.getFactory();
        try (JsonGenerator generator = factory.createGenerator(os, JsonEncoding.UTF8);){
            if (mapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartObject();
            generator.writeStringField("realm", realm.getName());
            generator.writeFieldName("federatedUsers");
            generator.writeStartArray();
            for (String userId : usersToExport) {
                UserRepresentation userRep = ExportUtils.exportFederatedUser(session, realm, userId);
                generator.writeObject((Object)userRep);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static UserRepresentation exportFederatedUser(KeycloakSession session, RealmModel realm, String id) {
        Set requiredActions;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setId(id);
        MultivaluedHashMap attributes = session.userFederatedStorage().getAttributes(realm, id);
        if (attributes.size() > 0) {
            HashMap attrs = new HashMap();
            attrs.putAll(attributes);
            userRep.setAttributes(attrs);
        }
        if ((requiredActions = session.userFederatedStorage().getRequiredActions(realm, id)).size() > 0) {
            LinkedList actions = new LinkedList();
            actions.addAll(requiredActions);
            userRep.setRequiredActions(actions);
        }
        Set socialLinks = session.userFederatedStorage().getFederatedIdentities(id, realm);
        ArrayList<FederatedIdentityRepresentation> socialLinkReps = new ArrayList<FederatedIdentityRepresentation>();
        for (FederatedIdentityModel socialLink : socialLinks) {
            FederatedIdentityRepresentation socialLinkRep = ExportUtils.exportSocialLink(socialLink);
            socialLinkReps.add(socialLinkRep);
        }
        if (socialLinkReps.size() > 0) {
            userRep.setFederatedIdentities(socialLinkReps);
        }
        Set roles = session.userFederatedStorage().getRoleMappings(realm, id);
        ArrayList<String> realmRoleNames = new ArrayList<String>();
        HashMap<String, ArrayList<String>> clientRoleNames = new HashMap<String, ArrayList<String>>();
        for (RoleModel role : roles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoleNames.add(role.getName());
                continue;
            }
            ClientModel client = (ClientModel)role.getContainer();
            String clientId = client.getClientId();
            ArrayList<String> currentClientRoles = (ArrayList<String>)clientRoleNames.get(clientId);
            if (currentClientRoles == null) {
                currentClientRoles = new ArrayList<String>();
                clientRoleNames.put(clientId, currentClientRoles);
            }
            currentClientRoles.add(role.getName());
        }
        if (realmRoleNames.size() > 0) {
            userRep.setRealmRoles(realmRoleNames);
        }
        if (clientRoleNames.size() > 0) {
            userRep.setClientRoles(clientRoleNames);
        }
        List creds = session.userFederatedStorage().getStoredCredentials(realm, id);
        ArrayList<CredentialRepresentation> credReps = new ArrayList<CredentialRepresentation>();
        for (CredentialModel cred : creds) {
            CredentialRepresentation credRep = ExportUtils.exportCredential(cred);
            credReps.add(credRep);
        }
        userRep.setCredentials(credReps);
        List consents = session.users().getConsents(realm, id);
        LinkedList<UserConsentRepresentation> consentReps = new LinkedList<UserConsentRepresentation>();
        for (UserConsentModel consent : consents) {
            UserConsentRepresentation consentRep = ModelToRepresentation.toRepresentation((UserConsentModel)consent);
            consentReps.add(consentRep);
        }
        if (consentReps.size() > 0) {
            userRep.setClientConsents(consentReps);
        }
        LinkedList<String> groups = new LinkedList<String>();
        for (GroupModel group : session.userFederatedStorage().getGroups(realm, id)) {
            groups.add(ModelToRepresentation.buildGroupPath((GroupModel)group));
        }
        userRep.setGroups(groups);
        return userRep;
    }
}

