/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.JOSE;
import org.keycloak.jose.JOSEParser;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.LockObjectsForModification;
import org.keycloak.vault.VaultStringSecret;

public class OIDCIdentityProvider
extends AbstractOAuth2IdentityProvider<OIDCIdentityProviderConfig>
implements ExchangeExternalToken {
    protected static final Logger logger = Logger.getLogger(OIDCIdentityProvider.class);
    public static final String SCOPE_OPENID = "openid";
    public static final String FEDERATED_ID_TOKEN = "FEDERATED_ID_TOKEN";
    public static final String USER_INFO = "UserInfo";
    public static final String FEDERATED_ACCESS_TOKEN_RESPONSE = "FEDERATED_ACCESS_TOKEN_RESPONSE";
    public static final String VALIDATED_ID_TOKEN = "VALIDATED_ID_TOKEN";
    public static final String ACCESS_TOKEN_EXPIRATION = "accessTokenExpiration";
    public static final String EXCHANGE_PROVIDER = "EXCHANGE_PROVIDER";
    public static final String VALIDATED_ACCESS_TOKEN = "VALIDATED_ACCESS_TOKEN";
    private static final String BROKER_NONCE_PARAM = "BROKER_NONCE";
    private static final MediaType APPLICATION_JWT_TYPE = MediaType.valueOf((String)"application/jwt");

    public OIDCIdentityProvider(KeycloakSession session, OIDCIdentityProviderConfig config) {
        super(session, config);
        String defaultScope = config.getDefaultScope();
        if (!defaultScope.contains(SCOPE_OPENID)) {
            config.setDefaultScope(("openid " + defaultScope).trim());
        }
    }

    @Override
    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new OIDCEndpoint(callback, realm, event, this);
    }

    public String refreshTokenForLogout(KeycloakSession session, UserSessionModel userSession) {
        String string;
        block8: {
            String refreshToken = userSession.getNote("FEDERATED_REFRESH_TOKEN");
            VaultStringSecret vaultStringSecret = session.vault().getStringSecret(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret());
            try {
                string = this.getRefreshTokenRequest(session, refreshToken, ((OIDCIdentityProviderConfig)this.getConfig()).getClientId(), vaultStringSecret.get().orElse(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret())).asString();
                if (vaultStringSecret == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (vaultStringSecret != null) {
                        try {
                            vaultStringSecret.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            vaultStringSecret.close();
        }
        return string;
    }

    public void backchannelLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl() == null || ((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl().trim().equals("") || !((OIDCIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            return;
        }
        String idToken = userSession.getNote(FEDERATED_ID_TOKEN);
        if (idToken == null) {
            return;
        }
        this.backchannelLogout(userSession, idToken);
    }

    protected void backchannelLogout(UserSessionModel userSession, String idToken) {
        String sessionId = userSession.getId();
        UriBuilder logoutUri = UriBuilder.fromUri((String)((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl()).queryParam("state", new Object[]{sessionId});
        logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        final String url = logoutUri.build(new Object[0]).toString();
        CloseableHttpClient client = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        this.session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction((HttpClient)client){
            final /* synthetic */ HttpClient val$client;
            {
                this.val$client = httpClient;
            }

            protected void commitImpl() {
                try {
                    boolean success;
                    int status = SimpleHttp.doGet((String)url, (HttpClient)this.val$client).asStatus();
                    boolean bl = success = status >= 200 && status < 400;
                    if (!success) {
                        logger.warn((Object)("Failed backchannel broker logout to: " + url));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed backchannel broker logout to: " + url), (Throwable)e);
                }
            }

            protected void rollbackImpl() {
            }
        });
    }

    public Response keycloakInitiatedBrowserLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl() == null || ((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl().trim().equals("")) {
            return null;
        }
        String idToken = userSession.getNote(FEDERATED_ID_TOKEN);
        if (idToken != null && ((OIDCIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            this.backchannelLogout(userSession, idToken);
            return null;
        }
        String sessionId = userSession.getId();
        UriBuilder logoutUri = UriBuilder.fromUri((String)((OIDCIdentityProviderConfig)this.getConfig()).getLogoutUrl()).queryParam("state", new Object[]{sessionId});
        if (idToken != null) {
            logoutUri.queryParam("id_token_hint", new Object[]{idToken});
        }
        String redirect = RealmsResource.brokerUrl(uriInfo).path(IdentityBrokerService.class, "getEndpoint").path(OIDCEndpoint.class, "logoutResponse").build(new Object[]{realm.getName(), ((OIDCIdentityProviderConfig)this.getConfig()).getAlias()}).toString();
        logoutUri.queryParam("post_logout_redirect_uri", new Object[]{redirect});
        Response response = Response.status((int)302).location(logoutUri.build(new Object[0])).build();
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Response exchangeStoredToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        FederatedIdentityModel model = this.session.users().getFederatedIdentity(authorizedClient.getRealm(), tokenSubject, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
        if (model == null || model.getToken() == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeNotLinked(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret());){
            String modelTokenString = model.getToken();
            AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)modelTokenString, AccessTokenResponse.class);
            Integer exp = (Integer)tokenResponse.getOtherClaims().get(ACCESS_TOKEN_EXPIRATION);
            if (exp != null && exp < Time.currentTime()) {
                if (tokenResponse.getRefreshToken() == null) {
                    Response response = this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
                    return response;
                }
                String response = this.getRefreshTokenRequest(this.session, tokenResponse.getRefreshToken(), ((OIDCIdentityProviderConfig)this.getConfig()).getClientId(), vaultStringSecret.get().orElse(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret())).asString();
                if (response.contains("error")) {
                    logger.debugv("Error refreshing token, refresh token expiration?: {0}", (Object)response);
                    model.setToken(null);
                    this.session.users().updateFederatedIdentity(authorizedClient.getRealm(), tokenSubject, model);
                    event.detail("reason", "requested_issuer token expired");
                    event.error("invalid_token");
                    Response response2 = this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
                    return response2;
                }
                AccessTokenResponse newResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response, AccessTokenResponse.class);
                if (newResponse.getExpiresIn() > 0L) {
                    int accessTokenExpiration = Time.currentTime() + (int)newResponse.getExpiresIn();
                    newResponse.getOtherClaims().put(ACCESS_TOKEN_EXPIRATION, accessTokenExpiration);
                }
                if (newResponse.getRefreshToken() == null && tokenResponse.getRefreshToken() != null) {
                    newResponse.setRefreshToken(tokenResponse.getRefreshToken());
                    newResponse.setRefreshExpiresIn(tokenResponse.getRefreshExpiresIn());
                }
                response = JsonSerialization.writeValueAsString((Object)newResponse);
                String oldToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
                if (oldToken != null && oldToken.equals(tokenResponse.getToken())) {
                    int accessTokenExpiration = newResponse.getExpiresIn() > 0L ? Time.currentTime() + (int)newResponse.getExpiresIn() : 0;
                    tokenUserSession.setNote("FEDERATED_TOKEN_EXPIRATION", Long.toString(accessTokenExpiration));
                    tokenUserSession.setNote("FEDERATED_REFRESH_TOKEN", newResponse.getRefreshToken());
                    tokenUserSession.setNote("FEDERATED_ACCESS_TOKEN", newResponse.getToken());
                    tokenUserSession.setNote(FEDERATED_ID_TOKEN, newResponse.getIdToken());
                }
                model.setToken(response);
                tokenResponse = newResponse;
            } else if (exp != null) {
                tokenResponse.setExpiresIn((long)(exp - Time.currentTime()));
            }
            tokenResponse.setIdToken(null);
            tokenResponse.setRefreshToken(null);
            tokenResponse.setRefreshExpiresIn(0L);
            tokenResponse.getOtherClaims().clear();
            tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
            tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
            event.success();
            Response response = Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processAccessTokenResponse(BrokeredIdentityContext context, AccessTokenResponse response) {
        if (((OIDCIdentityProviderConfig)this.getConfig()).isAccessTokenJwt()) {
            JsonWebToken access = this.validateToken(response.getToken(), true);
            context.getContextData().put(VALIDATED_ACCESS_TOKEN, access);
        }
    }

    protected SimpleHttp getRefreshTokenRequest(KeycloakSession session, String refreshToken, String clientId, String clientSecret) {
        SimpleHttp refreshTokenRequest = SimpleHttp.doPost((String)((OIDCIdentityProviderConfig)this.getConfig()).getTokenUrl(), (KeycloakSession)session).param("refresh_token", refreshToken).param("grant_type", "refresh_token");
        return this.authenticateTokenRequest(refreshTokenRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Response exchangeSessionToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        String refreshToken = tokenUserSession.getNote("FEDERATED_REFRESH_TOKEN");
        String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
        String idToken = tokenUserSession.getNote(FEDERATED_ID_TOKEN);
        if (accessToken == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret());){
            long expiration = Long.parseLong(tokenUserSession.getNote("FEDERATED_TOKEN_EXPIRATION"));
            if (expiration == 0L || expiration > (long)Time.currentTime()) {
                AccessTokenResponse tokenResponse = new AccessTokenResponse();
                tokenResponse.setExpiresIn(expiration);
                tokenResponse.setToken(accessToken);
                tokenResponse.setIdToken(null);
                tokenResponse.setRefreshToken(null);
                tokenResponse.setRefreshExpiresIn(0L);
                tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
                tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
                event.success();
                Response response = Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
                return response;
            }
            String response = this.getRefreshTokenRequest(this.session, refreshToken, ((OIDCIdentityProviderConfig)this.getConfig()).getClientId(), vaultStringSecret.get().orElse(((OIDCIdentityProviderConfig)this.getConfig()).getClientSecret())).asString();
            if (response.contains("error")) {
                logger.debugv("Error refreshing token, refresh token expiration?: {0}", (Object)response);
                event.detail("reason", "requested_issuer token expired");
                event.error("invalid_token");
                Response response2 = this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
                return response2;
            }
            AccessTokenResponse newResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response, AccessTokenResponse.class);
            long accessTokenExpiration = newResponse.getExpiresIn() > 0L ? (long)Time.currentTime() + newResponse.getExpiresIn() : 0L;
            tokenUserSession.setNote("FEDERATED_TOKEN_EXPIRATION", Long.toString(accessTokenExpiration));
            tokenUserSession.setNote("FEDERATED_REFRESH_TOKEN", newResponse.getRefreshToken());
            tokenUserSession.setNote("FEDERATED_ACCESS_TOKEN", newResponse.getToken());
            tokenUserSession.setNote(FEDERATED_ID_TOKEN, newResponse.getIdToken());
            newResponse.setIdToken(null);
            newResponse.setRefreshToken(null);
            newResponse.setRefreshExpiresIn(0L);
            newResponse.getOtherClaims().clear();
            newResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
            newResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
            event.success();
            Response response3 = Response.ok((Object)newResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
            return response3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BrokeredIdentityContext getFederatedIdentity(String response) {
        AccessTokenResponse tokenResponse = null;
        try {
            tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response, AccessTokenResponse.class);
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Could not decode access token response.", (Throwable)e);
        }
        String accessToken = this.verifyAccessToken(tokenResponse);
        String encodedIdToken = tokenResponse.getIdToken();
        JsonWebToken idToken = this.validateToken(encodedIdToken);
        if (((OIDCIdentityProviderConfig)this.getConfig()).isPassMaxAge()) {
            AuthenticationSessionModel authSession = this.session.getContext().getAuthenticationSession();
            if (this.isAuthTimeExpired(idToken, authSession)) {
                throw new IdentityBrokerException("User not re-authenticated by the target OpenID Provider");
            }
            Object authTime = idToken.getOtherClaims().get("auth_time");
            if (authTime != null) {
                authSession.setClientNote("AUTH_TIME_BROKER", authTime.toString());
            }
        }
        try {
            BrokeredIdentityContext identity = this.extractIdentity(tokenResponse, accessToken, idToken);
            if (!identity.getId().equals(idToken.getSubject())) {
                throw new IdentityBrokerException("Mismatch between the subject in the id_token and the subject from the user_info endpoint");
            }
            if (((OIDCIdentityProviderConfig)this.getConfig()).isFilteredByClaims()) {
                String filterName = ((OIDCIdentityProviderConfig)this.getConfig()).getClaimFilterName();
                String filterValue = ((OIDCIdentityProviderConfig)this.getConfig()).getClaimFilterValue();
                logger.tracef("Filtering user %s by %s=%s", idToken.getOtherClaims().get(this.getusernameClaimNameForIdToken()), (Object)filterName, (Object)filterValue);
                if (idToken.getOtherClaims().containsKey(filterName)) {
                    Object claimObject = idToken.getOtherClaims().get(filterName);
                    ArrayList<String> claimValues = new ArrayList<String>();
                    if (claimObject instanceof List) {
                        ((List)claimObject).forEach(v -> claimValues.add(Objects.toString(v)));
                    } else {
                        claimValues.add(Objects.toString(claimObject));
                    }
                    logger.tracef("Found claim %s with values %s", (Object)filterName, claimValues);
                    if (!claimValues.stream().anyMatch(v -> v.matches(filterValue))) {
                        logger.warnf("Claim %s has values \"%s\" that does not match the expected filter \"%s\"", (Object)filterName, claimValues, (Object)filterValue);
                        throw new IdentityBrokerException(String.format("Unmatched claim value for %s.", filterName)).withMessageCode("federatedIdentityUnmatchedEssentialClaimMessage");
                    }
                } else {
                    logger.debugf("Claim %s was not found", (Object)filterName);
                    throw new IdentityBrokerException(String.format("Claim %s not found", filterName)).withMessageCode("federatedIdentityUnmatchedEssentialClaimMessage");
                }
            }
            if (!((OIDCIdentityProviderConfig)this.getConfig()).isDisableNonce()) {
                identity.getContextData().put(BROKER_NONCE_PARAM, idToken.getOtherClaims().get("nonce"));
            }
            if (((OIDCIdentityProviderConfig)this.getConfig()).isStoreToken()) {
                if (tokenResponse.getExpiresIn() > 0L) {
                    long accessTokenExpiration = (long)Time.currentTime() + tokenResponse.getExpiresIn();
                    tokenResponse.getOtherClaims().put(ACCESS_TOKEN_EXPIRATION, accessTokenExpiration);
                    response = JsonSerialization.writeValueAsString((Object)tokenResponse);
                }
                identity.setToken(response);
            }
            return identity;
        }
        catch (IdentityBrokerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not fetch attributes from userinfo endpoint.", (Throwable)e);
        }
    }

    protected boolean isAuthTimeExpired(JsonWebToken idToken, AuthenticationSessionModel authSession) {
        int maxAgeInt;
        String maxAge = authSession.getClientNote("max_age");
        if (maxAge == null) {
            return false;
        }
        String authTime = idToken.getOtherClaims().getOrDefault("auth_time", "0").toString();
        int authTimeInt = authTime == null ? 0 : Integer.parseInt(authTime);
        if (authTimeInt + (maxAgeInt = Integer.parseInt(maxAge)) < Time.currentTime()) {
            logger.debugf("Invalid auth_time claim. User not re-authenticated by the target OP.", new Object[0]);
            return true;
        }
        return false;
    }

    protected BrokeredIdentityContext extractIdentity(AccessTokenResponse tokenResponse, String accessToken, JsonWebToken idToken) throws IOException {
        String userInfoUrl;
        String id = idToken.getSubject();
        BrokeredIdentityContext identity = new BrokeredIdentityContext(id);
        String name = (String)idToken.getOtherClaims().get("name");
        String givenName = (String)idToken.getOtherClaims().get("given_name");
        String familyName = (String)idToken.getOtherClaims().get("family_name");
        String preferredUsername = (String)idToken.getOtherClaims().get(this.getusernameClaimNameForIdToken());
        String email = (String)idToken.getOtherClaims().get("email");
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isDisableUserInfoService() && (userInfoUrl = this.getUserInfoUrl()) != null && !userInfoUrl.isEmpty() && accessToken != null) {
            JsonNode userInfo;
            MediaType contentMediaType;
            SimpleHttp.Response response = this.executeRequest(userInfoUrl, SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken));
            String contentType = response.getFirstHeader("Content-Type");
            try {
                contentMediaType = MediaType.valueOf((String)contentType);
            }
            catch (IllegalArgumentException ex) {
                contentMediaType = null;
            }
            if (contentMediaType == null || contentMediaType.isWildcardSubtype() || contentMediaType.isWildcardType()) {
                throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(contentMediaType)) {
                userInfo = response.asJson();
            } else if (APPLICATION_JWT_TYPE.isCompatible(contentMediaType)) {
                userInfo = (JsonNode)JsonSerialization.readValue((String)this.parseTokenInput(response.asString(), false), JsonNode.class);
            } else {
                throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
            }
            id = this.getJsonProperty(userInfo, "sub");
            name = this.getJsonProperty(userInfo, "name");
            givenName = this.getJsonProperty(userInfo, "given_name");
            familyName = this.getJsonProperty(userInfo, "family_name");
            preferredUsername = this.getUsernameFromUserInfo(userInfo);
            email = this.getJsonProperty(userInfo, "email");
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, userInfo, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
        }
        identity.getContextData().put(VALIDATED_ID_TOKEN, idToken);
        identity.setId(id);
        if (givenName != null) {
            identity.setFirstName(givenName);
        }
        if (familyName != null) {
            identity.setLastName(familyName);
        }
        if (givenName == null && familyName == null) {
            identity.setName(name);
        }
        identity.setEmail(email);
        identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
        if (preferredUsername == null) {
            preferredUsername = email;
        }
        if (preferredUsername == null) {
            preferredUsername = id;
        }
        identity.setUsername(preferredUsername);
        if (tokenResponse != null && tokenResponse.getSessionState() != null) {
            identity.setBrokerSessionId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + tokenResponse.getSessionState());
        }
        if (tokenResponse != null) {
            identity.getContextData().put(FEDERATED_ACCESS_TOKEN_RESPONSE, tokenResponse);
        }
        if (tokenResponse != null) {
            this.processAccessTokenResponse(identity, tokenResponse);
        }
        return identity;
    }

    protected String getusernameClaimNameForIdToken() {
        return "preferred_username";
    }

    protected String getUserInfoUrl() {
        return ((OIDCIdentityProviderConfig)this.getConfig()).getUserInfoUrl();
    }

    private SimpleHttp.Response executeRequest(String url, SimpleHttp request) throws IOException {
        SimpleHttp.Response response = request.asResponse();
        if (response.getStatus() != 200) {
            String msg = "failed to invoke url [" + url + "]";
            try {
                String tmp = response.asString();
                if (tmp != null) {
                    msg = tmp;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IdentityBrokerException("Failed to invoke url [" + url + "]: " + msg);
        }
        return response;
    }

    private String verifyAccessToken(AccessTokenResponse tokenResponse) {
        String accessToken = tokenResponse.getToken();
        if (accessToken == null) {
            throw new IdentityBrokerException("No access_token from server. error='" + tokenResponse.getError() + "', error_description='" + tokenResponse.getErrorDescription() + "', error_uri='" + tokenResponse.getErrorUri() + "'");
        }
        return accessToken;
    }

    protected KeyWrapper getIdentityProviderKeyWrapper(JWSInput jws) {
        return PublicKeyStorageManager.getIdentityProviderKeyWrapper(this.session, this.session.getContext().getRealm(), (OIDCIdentityProviderConfig)this.getConfig(), jws);
    }

    protected boolean verify(JWSInput jws) {
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isValidateSignature()) {
            return true;
        }
        try {
            SignatureProvider signatureProvider;
            KeyWrapper key = this.getIdentityProviderKeyWrapper(jws);
            if (key == null) {
                logger.debugf("Failed to verify token, key not found for algorithm %s", (Object)jws.getHeader().getRawAlgorithm());
                return false;
            }
            if (key.getAlgorithm() == null) {
                key.setAlgorithm(jws.getHeader().getRawAlgorithm());
            }
            if ((signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, jws.getHeader().getRawAlgorithm())) == null) {
                logger.debugf("Failed to verify token, signature provider not found for algorithm %s", (Object)jws.getHeader().getRawAlgorithm());
                return false;
            }
            return signatureProvider.verifier(key).verify(jws.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jws.getSignature());
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to verify token", (Throwable)e);
            return false;
        }
    }

    protected String parseTokenInput(String encodedToken, boolean shouldBeSigned) {
        if (encodedToken == null) {
            throw new IdentityBrokerException("No token from server.");
        }
        try {
            JWSInput jws;
            JOSE joseToken = JOSEParser.parse((String)encodedToken);
            if (joseToken instanceof JWE) {
                JWE jwe = (JWE)joseToken;
                KeyWrapper key = jwe.getHeader().getKeyId() == null ? this.session.keys().getActiveKey(this.session.getContext().getRealm(), KeyUse.ENC, jwe.getHeader().getRawAlgorithm()) : this.session.keys().getKey(this.session.getContext().getRealm(), jwe.getHeader().getKeyId(), KeyUse.ENC, jwe.getHeader().getRawAlgorithm());
                if (key == null || key.getPrivateKey() == null) {
                    throw new IdentityBrokerException("Private key not found in the realm to decrypt token algorithm " + jwe.getHeader().getRawAlgorithm());
                }
                jwe.getKeyStorage().setDecryptionKey(key.getPrivateKey());
                jwe.verifyAndDecodeJwe();
                String content = new String(jwe.getContent(), StandardCharsets.UTF_8);
                try {
                    joseToken = JOSEParser.parse((String)content);
                }
                catch (Exception e) {
                    if (shouldBeSigned) {
                        throw new IdentityBrokerException("Token is not a signed JWS", (Throwable)e);
                    }
                    return content;
                }
                if (!(joseToken instanceof JWSInput)) {
                    throw new IdentityBrokerException("Invalid token type");
                }
                jws = (JWSInput)joseToken;
            } else if (joseToken instanceof JWSInput) {
                jws = (JWSInput)joseToken;
            } else {
                throw new IdentityBrokerException("Invalid token type");
            }
            if (!this.verify(jws)) {
                throw new IdentityBrokerException("token signature validation failed");
            }
            return new String(jws.getContent(), StandardCharsets.UTF_8);
        }
        catch (JWEException e) {
            throw new IdentityBrokerException("Invalid token", (Throwable)e);
        }
    }

    public JsonWebToken validateToken(String encodedToken) {
        boolean ignoreAudience = false;
        return this.validateToken(encodedToken, ignoreAudience);
    }

    protected JsonWebToken validateToken(String encodedToken, boolean ignoreAudience) {
        JsonWebToken token;
        try {
            token = (JsonWebToken)JsonSerialization.readValue((String)this.parseTokenInput(encodedToken, true), JsonWebToken.class);
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Invalid token", (Throwable)e);
        }
        String iss = token.getIssuer();
        if (!token.isActive(((OIDCIdentityProviderConfig)this.getConfig()).getAllowedClockSkew())) {
            throw new IdentityBrokerException("Token is no longer valid");
        }
        if (!ignoreAudience && !token.hasAudience(((OIDCIdentityProviderConfig)this.getConfig()).getClientId())) {
            throw new IdentityBrokerException("Wrong audience from token.");
        }
        if (!ignoreAudience && token.getIssuedFor() != null && !((OIDCIdentityProviderConfig)this.getConfig()).getClientId().equals(token.getIssuedFor())) {
            throw new IdentityBrokerException("Token issued for does not match client id");
        }
        String trustedIssuers = ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer();
        if (trustedIssuers != null && trustedIssuers.length() > 0) {
            String[] issuers;
            for (String trustedIssuer : issuers = trustedIssuers.split(",")) {
                if (iss == null || !iss.equals(trustedIssuer.trim())) continue;
                return token;
            }
            throw new IdentityBrokerException("Wrong issuer from token. Got: " + iss + " expected: " + ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer());
        }
        return token;
    }

    @Override
    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        AccessTokenResponse tokenResponse = (AccessTokenResponse)context.getContextData().get(FEDERATED_ACCESS_TOKEN_RESPONSE);
        int currentTime = Time.currentTime();
        long expiration = tokenResponse.getExpiresIn() > 0L ? tokenResponse.getExpiresIn() + (long)currentTime : 0L;
        authSession.setUserSessionNote("FEDERATED_TOKEN_EXPIRATION", Long.toString(expiration));
        authSession.setUserSessionNote("FEDERATED_REFRESH_TOKEN", tokenResponse.getRefreshToken());
        authSession.setUserSessionNote("FEDERATED_ACCESS_TOKEN", tokenResponse.getToken());
        authSession.setUserSessionNote(FEDERATED_ID_TOKEN, tokenResponse.getIdToken());
    }

    @Override
    protected String getDefaultScopes() {
        return SCOPE_OPENID;
    }

    @Override
    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        String requestedIssuer;
        if (!this.supportsExternalExchange()) {
            return false;
        }
        String string = requestedIssuer = params == null ? null : (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        if (requestedIssuer.equals(((OIDCIdentityProviderConfig)this.getConfig()).getAlias())) {
            return true;
        }
        String trustedIssuers = ((OIDCIdentityProviderConfig)this.getConfig()).getIssuer();
        if (trustedIssuers != null && trustedIssuers.length() > 0) {
            String[] issuers;
            for (String trustedIssuer : issuers = trustedIssuers.split(",")) {
                if (!requestedIssuer.equals(trustedIssuer.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        String userInfoUrl = this.getUserInfoUrl();
        if (((OIDCIdentityProviderConfig)this.getConfig()).isDisableUserInfoService() || userInfoUrl == null || userInfoUrl.isEmpty()) {
            event.detail("reason", "user info service disabled");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        return userInfoUrl;
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode userInfo) {
        String id = this.getJsonProperty(userInfo, "sub");
        if (id == null) {
            event.detail("reason", "sub claim is null from user info json");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        BrokeredIdentityContext identity = new BrokeredIdentityContext(id);
        String name = this.getJsonProperty(userInfo, "name");
        String preferredUsername = this.getUsernameFromUserInfo(userInfo);
        String givenName = this.getJsonProperty(userInfo, "given_name");
        String familyName = this.getJsonProperty(userInfo, "family_name");
        String email = this.getJsonProperty(userInfo, "email");
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(identity, userInfo, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
        identity.setId(id);
        if (givenName != null) {
            identity.setFirstName(givenName);
        }
        if (familyName != null) {
            identity.setLastName(familyName);
        }
        if (givenName == null && familyName == null) {
            identity.setName(name);
        }
        identity.setEmail(email);
        identity.setBrokerUserId(((OIDCIdentityProviderConfig)this.getConfig()).getAlias() + "." + id);
        if (preferredUsername == null) {
            preferredUsername = email;
        }
        if (preferredUsername == null) {
            preferredUsername = id;
        }
        identity.setUsername(preferredUsername);
        return identity;
    }

    protected String getUsernameFromUserInfo(JsonNode userInfo) {
        return this.getJsonProperty(userInfo, "preferred_username");
    }

    protected final BrokeredIdentityContext validateJwt(EventBuilder event, String subjectToken, String subjectTokenType) {
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isValidateSignature()) {
            return this.validateExternalTokenThroughUserInfo(event, subjectToken, subjectTokenType);
        }
        event.detail("validation_method", "signature");
        if (((OIDCIdentityProviderConfig)this.getConfig()).isUseJwksUrl()) {
            if (((OIDCIdentityProviderConfig)this.getConfig()).getJwksUrl() == null) {
                event.detail("reason", "jwks url unset");
                event.error("invalid_config");
                throw new ErrorResponseException("invalid_config", "Invalid server config", Response.Status.BAD_REQUEST);
            }
        } else if (((OIDCIdentityProviderConfig)this.getConfig()).getPublicKeySignatureVerifier() == null) {
            event.detail("reason", "public key unset");
            event.error("invalid_config");
            throw new ErrorResponseException("invalid_config", "Invalid server config", Response.Status.BAD_REQUEST);
        }
        JsonWebToken parsedToken = null;
        try {
            parsedToken = this.validateToken(subjectToken, true);
        }
        catch (IdentityBrokerException e) {
            logger.debug((Object)"Unable to validate token for exchange", (Throwable)e);
            event.detail("reason", "token validation failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        try {
            boolean idTokenType = "urn:ietf:params:oauth:token-type:id_token".equals(subjectTokenType);
            BrokeredIdentityContext context = this.extractIdentity(null, idTokenType ? null : subjectToken, parsedToken);
            if (context == null) {
                event.detail("reason", "Failed to extract identity from token");
                event.error("invalid_token");
                throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
            }
            if (idTokenType) {
                context.getContextData().put(VALIDATED_ID_TOKEN, subjectToken);
            } else {
                context.getContextData().put(VALIDATED_ACCESS_TOKEN, parsedToken);
            }
            context.getContextData().put(EXCHANGE_PROVIDER, ((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
            context.setIdp((IdentityProvider)this);
            context.setIdpConfig(this.getConfig());
            return context;
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to extract identity from identity token", (Throwable)e);
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        if (!this.supportsExternalExchange()) {
            return null;
        }
        String subjectToken = (String)params.getFirst((Object)"subject_token");
        if (subjectToken == null) {
            event.detail("reason", "subject_token param unset");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        String subjectTokenType = (String)params.getFirst((Object)"subject_token_type");
        if (subjectTokenType == null) {
            subjectTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        if ("urn:ietf:params:oauth:token-type:jwt".equals(subjectTokenType) || "urn:ietf:params:oauth:token-type:id_token".equals(subjectTokenType)) {
            return this.validateJwt(event, subjectToken, subjectTokenType);
        }
        if ("urn:ietf:params:oauth:token-type:access_token".equals(subjectTokenType)) {
            return this.validateExternalTokenThroughUserInfo(event, subjectToken, subjectTokenType);
        }
        event.detail("reason", "subject_token_type invalid");
        event.error("invalid_token_type");
        throw new ErrorResponseException("invalid_token", "invalid token type", Response.Status.BAD_REQUEST);
    }

    @Override
    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        UriBuilder uriBuilder = super.createAuthorizationUrl(request);
        AuthenticationSessionModel authenticationSession = request.getAuthenticationSession();
        if (!((OIDCIdentityProviderConfig)this.getConfig()).isDisableNonce()) {
            String nonce = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(16));
            authenticationSession.setClientNote(BROKER_NONCE_PARAM, nonce);
            uriBuilder.queryParam("nonce", new Object[]{nonce});
        }
        String maxAge = request.getAuthenticationSession().getClientNote("max_age");
        if (((OIDCIdentityProviderConfig)this.getConfig()).isPassMaxAge() && maxAge != null) {
            uriBuilder.queryParam("max_age", new Object[]{maxAge});
        }
        return uriBuilder;
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, BrokeredIdentityContext context) {
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (authenticationSession == null || ((OIDCIdentityProviderConfig)this.getConfig()).isDisableNonce()) {
            return;
        }
        String nonce = (String)context.getContextData().get(BROKER_NONCE_PARAM);
        if (nonce == null) {
            throw new IdentityBrokerException("OpenID Provider [" + ((OIDCIdentityProviderConfig)this.getConfig()).getProviderId() + "] did not return a nonce");
        }
        String expectedNonce = authenticationSession.getClientNote(BROKER_NONCE_PARAM);
        if (!nonce.equals(expectedNonce)) {
            throw new ErrorResponseException("invalid_token", "invalid nonce", Response.Status.BAD_REQUEST);
        }
    }

    protected static class OIDCEndpoint
    extends AbstractOAuth2IdentityProvider.Endpoint {
        public OIDCEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event, OIDCIdentityProvider provider) {
            super(callback, realm, event, provider);
        }

        @Override
        public SimpleHttp generateTokenRequest(String authorizationCode) {
            SimpleHttp simpleHttp = super.generateTokenRequest(authorizationCode);
            return simpleHttp;
        }

        @GET
        @Path(value="logout_response")
        public Response logoutResponse(@QueryParam(value="state") String state) {
            if (state == null) {
                logger.error((Object)"no state parameter returned");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(this.realm, state));
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection);
                event.event(EventType.LOGOUT);
                event.error("user_session_not_found");
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "sessionNotActiveMessage", new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.headers);
        }
    }
}

