/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;

public class ErrorResponseException
extends WebApplicationException {
    private final Response response;
    private final String error;
    private final String errorDescription;
    private final Response.Status status;

    public ErrorResponseException(String error, String errorDescription, Response.Status status) {
        this.response = null;
        this.error = error;
        this.errorDescription = errorDescription;
        this.status = status;
    }

    public ErrorResponseException(Response response) {
        this.response = response;
        this.error = null;
        this.errorDescription = null;
        this.status = null;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public Response getResponse() {
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        if (session != null) {
            session.getTransactionManager().setRollbackOnly();
        }
        if (this.response != null) {
            return this.response;
        }
        OAuth2ErrorRepresentation errorRep = new OAuth2ErrorRepresentation(this.error, this.errorDescription);
        return Response.status((Response.Status)this.status).entity((Object)errorRep).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

