/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.util.Resteasy;
import org.keycloak.http.FormPartValue;
import org.keycloak.services.FormPartValueImpl;

public class HttpRequestImpl
implements org.keycloak.http.HttpRequest {
    private HttpRequest delegate;

    public HttpRequestImpl(HttpRequest delegate) {
        this.delegate = delegate;
    }

    public String getHttpMethod() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getHttpMethod();
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.delegate == null) {
            return null;
        }
        MediaType mediaType = this.getHttpHeaders().getMediaType();
        if (mediaType == null || !mediaType.isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            return new MultivaluedHashMap();
        }
        return this.delegate.getDecodedFormParameters();
    }

    public MultivaluedMap<String, FormPartValue> getMultiPartFormParameters() {
        try {
            MediaType mediaType = this.getHttpHeaders().getMediaType();
            if (!MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mediaType) || !mediaType.getParameters().containsKey("boundary")) {
                return new MultivaluedHashMap();
            }
            Providers providers = (Providers)Resteasy.getContextData(Providers.class);
            MessageBodyReader multiPartProvider = providers.getMessageBodyReader(MultipartFormDataInput.class, null, null, MediaType.MULTIPART_FORM_DATA_TYPE);
            MultipartFormDataInput inputs = (MultipartFormDataInput)multiPartProvider.readFrom(null, null, null, mediaType, this.getHttpHeaders().getRequestHeaders(), this.delegate.getInputStream());
            MultivaluedHashMap parts = new MultivaluedHashMap();
            for (Map.Entry entry : inputs.getValues().entrySet()) {
                for (FormValue value : (Collection)entry.getValue()) {
                    if (!value.isFileItem()) {
                        parts.add((Object)((String)entry.getKey()), (Object)new FormPartValueImpl(value.getValue()));
                        continue;
                    }
                    parts.add((Object)((String)entry.getKey()), (Object)new FormPartValueImpl(value.getFileItem().getInputStream()));
                }
            }
            return parts;
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to parse multi part request", cause);
        }
    }

    public HttpHeaders getHttpHeaders() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getHttpHeaders();
    }

    public X509Certificate[] getClientCertificateChain() {
        if (this.delegate == null) {
            return null;
        }
        return (X509Certificate[])this.delegate.getAttribute("jakarta.servlet.request.X509Certificate");
    }

    public UriInfo getUri() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getUri();
    }
}

