/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.impl;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.client.clienttype.ClientTypeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.services.clienttype.impl.DefaultClientType;

public class DefaultClientTypeProvider
implements ClientTypeProvider {
    private static final Logger logger = Logger.getLogger(DefaultClientTypeProvider.class);
    private final KeycloakSession session;
    private final Map<String, PropertyDescriptor> clientRepresentationProperties;

    public DefaultClientTypeProvider(KeycloakSession session, Map<String, PropertyDescriptor> clientRepresentationProperties) {
        this.session = session;
        this.clientRepresentationProperties = clientRepresentationProperties;
    }

    public ClientType getClientType(ClientTypeRepresentation clientTypeRep) {
        return new DefaultClientType(this.session, clientTypeRep, this.clientRepresentationProperties);
    }

    public ClientTypeRepresentation checkClientTypeConfig(ClientTypeRepresentation clientType) throws ClientTypeException {
        Map config = clientType.getConfig();
        for (Map.Entry entry : config.entrySet()) {
            String propertyName = (String)entry.getKey();
            ClientTypeRepresentation.PropertyConfig propConfig = (ClientTypeRepresentation.PropertyConfig)entry.getValue();
            if (propConfig.getApplicable() == null) {
                logger.errorf("Property '%s' does not have 'applicable' configured for client type '%s'", (Object)propertyName, (Object)clientType.getName());
                throw new ClientTypeException("Invalid configuration of 'applicable' property on client type");
            }
            if (propConfig.getApplicable().booleanValue() || propConfig.getReadOnly() == null && propConfig.getDefaultValue() == null) continue;
            logger.errorf("Property '%s' is not applicable and so should not have read-only or default-value set for client type '%s'", (Object)propertyName, (Object)clientType.getName());
            throw new ClientTypeException("Invalid configuration of property on client type");
        }
        return clientType;
    }
}

