/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientInitialAccessResource {
    private final AdminPermissionEvaluator auth;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    protected KeycloakSession session;

    public ClientInitialAccessResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_INITIAL_ACCESS_MODEL);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Tag(name="Client Initial Access")
    @Operation(summary="Create a new initial access token.")
    @APIResponse(responseCode="201", description="Created", content={@Content(schema=@Schema(implementation=ClientInitialAccessCreatePresentation.class))})
    public ClientInitialAccessPresentation create(ClientInitialAccessCreatePresentation config) {
        this.auth.clients().requireManage();
        int expiration = config.getExpiration() != null ? config.getExpiration() : 0;
        int count = config.getCount() != null ? config.getCount() : 1;
        ClientInitialAccessModel clientInitialAccessModel = this.session.realms().createClientInitialAccessModel(this.realm, expiration, count);
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), clientInitialAccessModel.getId()).representation(config).success();
        ClientInitialAccessPresentation rep = this.wrap(clientInitialAccessModel);
        String token = ClientRegistrationTokenUtils.createInitialAccessToken(this.session, this.realm, clientInitialAccessModel);
        rep.setToken(token);
        HttpResponse response = this.session.getContext().getHttpResponse();
        response.setStatus(Response.Status.CREATED.getStatusCode());
        response.addHeader("Location", this.session.getContext().getUri().getAbsolutePathBuilder().path(clientInitialAccessModel.getId()).build(new Object[0]).toString());
        return rep;
    }

    @GET
    @Produces(value={"application/json"})
    @Tag(name="Client Initial Access")
    @Operation
    public Stream<ClientInitialAccessPresentation> list() {
        this.auth.clients().requireView();
        return this.session.realms().listClientInitialAccessStream(this.realm).map(this::wrap);
    }

    @DELETE
    @Path(value="{id}")
    @Tag(name="Client Initial Access")
    @Operation
    public void delete(@PathParam(value="id") String id) {
        this.auth.clients().requireManage();
        this.session.realms().removeClientInitialAccessModel(this.realm, id);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    private ClientInitialAccessPresentation wrap(ClientInitialAccessModel model) {
        ClientInitialAccessPresentation rep = new ClientInitialAccessPresentation();
        rep.setId(model.getId());
        rep.setTimestamp(Integer.valueOf(model.getTimestamp()));
        rep.setExpiration(Integer.valueOf(model.getExpiration()));
        rep.setCount(Integer.valueOf(model.getCount()));
        rep.setRemainingCount(Integer.valueOf(model.getRemainingCount()));
        return rep;
    }
}

