/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.http.FormPartValue;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.IdentityProviderResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.utils.StringUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class IdentityProvidersResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public IdentityProvidersResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.IDENTITY_PROVIDER);
    }

    @Path(value="/providers/{provider_id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Get the identity provider factory for that provider id")
    public IdentityProviderFactory getIdentityProviderFactory(@Parameter(description="The provider id to get the factory") @PathParam(value="provider_id") String providerId) {
        this.auth.realm().requireViewIdentityProviders();
        IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
        if (providerFactory != null) {
            return providerFactory;
        }
        throw new BadRequestException();
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(description="Import identity provider from uploaded JSON file")
    public Map<String, String> importFrom() throws IOException {
        this.auth.realm().requireManageIdentityProviders();
        MultivaluedMap formDataMap = this.session.getContext().getHttpRequest().getMultiPartFormParameters();
        if (!formDataMap.containsKey((Object)"providerId") || !formDataMap.containsKey((Object)"file")) {
            throw new BadRequestException();
        }
        String providerId = ((FormPartValue)formDataMap.getFirst((Object)"providerId")).asString();
        InputStream inputStream = ((FormPartValue)formDataMap.getFirst((Object)"file")).asInputStream();
        IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
        Map config = providerFactory.parseConfig(this.session, inputStream);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="import-config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Import identity provider from JSON body")
    public Map<String, String> importFrom(@Parameter(description="JSON body") Map<String, Object> data) throws IOException {
        this.auth.realm().requireManageIdentityProviders();
        if (data == null || !data.containsKey("providerId") || !data.containsKey("fromUrl")) {
            throw new BadRequestException();
        }
        ReservedCharValidator.validateNoSpace((String)((String)data.get("alias")));
        String providerId = data.get("providerId").toString();
        String from = data.get("fromUrl").toString();
        InputStream inputStream = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).get(from);
        try {
            IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
            Map config = providerFactory.parseConfig(this.session, inputStream);
            config.put("metadataDescriptorUrl", from);
            Map map = config;
            return map;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @GET
    @Path(value="instances")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="List identity providers")
    public Stream<IdentityProviderRepresentation> getIdentityProviders(@Parameter(description="Filter specific providers by name. Search can be prefix (name*), contains (*name*) or exact (\"name\"). Default prefixed.") @QueryParam(value="search") String search, @Parameter(description="Boolean which defines whether brief representations are returned (default: false)") @QueryParam(value="briefRepresentation") Boolean briefRepresentation, @Parameter(description="Pagination offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults) {
        this.auth.realm().requireViewIdentityProviders();
        if (maxResults == null) {
            maxResults = 100;
        }
        Function<IdentityProviderModel, IdentityProviderRepresentation> toRepresentation = briefRepresentation != null && briefRepresentation != false ? m -> ModelToRepresentation.toBriefRepresentation((RealmModel)this.realm, (IdentityProviderModel)m) : m -> StripSecretsUtils.strip((IdentityProviderRepresentation)ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)m));
        Stream<IdentityProviderModel> stream = this.realm.getIdentityProvidersStream().sorted(new IdPComparator());
        if (!StringUtil.isBlank((String)search)) {
            stream = stream.filter(this.predicateByName(search));
        }
        if (firstResult != null) {
            stream = stream.skip(firstResult.intValue());
        }
        return stream.limit(maxResults.intValue()).map(toRepresentation);
    }

    private Predicate<IdentityProviderModel> predicateByName(String search) {
        if (search.startsWith("\"") && search.endsWith("\"")) {
            String name = search.substring(1, search.length() - 1);
            return m -> m.getAlias().equals(name);
        }
        if (search.startsWith("*") && search.endsWith("*")) {
            String name = search.substring(1, search.length() - 1);
            return m -> m.getAlias().contains(name);
        }
        if (search.endsWith("*")) {
            String name = search.substring(0, search.length() - 1);
            return m -> m.getAlias().startsWith(name);
        }
        return m -> m.getAlias().startsWith(search);
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Create a new identity provider")
    public Response create(@Parameter(description="JSON body") IdentityProviderRepresentation representation) {
        this.auth.realm().requireManageIdentityProviders();
        ReservedCharValidator.validateNoSpace((String)representation.getAlias());
        try {
            IdentityProviderModel identityProvider = RepresentationToModel.toModel((RealmModel)this.realm, (IdentityProviderRepresentation)representation, (KeycloakSession)this.session);
            this.realm.addIdentityProvider(identityProvider);
            representation.setInternalId(identityProvider.getInternalId());
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), identityProvider.getAlias()).representation(StripSecretsUtils.strip((IdentityProviderRepresentation)representation)).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(representation.getAlias()).build(new Object[0])).build();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Invalid request";
            }
            throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Identity Provider " + representation.getAlias() + " already exists");
        }
    }

    @Path(value="instances/{alias}")
    public IdentityProviderResource getIdentityProvider(@PathParam(value="alias") String alias) {
        this.auth.realm().requireViewIdentityProviders();
        IdentityProviderModel identityProviderModel = this.realm.getIdentityProvidersStream().filter(p -> Objects.equals(p.getAlias(), alias) || Objects.equals(p.getInternalId(), alias)).findFirst().orElse(null);
        return new IdentityProviderResource(this.auth, this.realm, this.session, identityProviderModel, this.adminEvent);
    }

    private IdentityProviderFactory getProviderFactoryById(String providerId) {
        return this.getProviderFactories().filter(providerFactory -> Objects.equals(providerId, providerFactory.getId())).map(IdentityProviderFactory.class::cast).findFirst().orElse(null);
    }

    private Stream<ProviderFactory> getProviderFactories() {
        return Stream.concat(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class), this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class));
    }

    private static class IdPComparator
    implements Comparator<IdentityProviderModel> {
        private IdPComparator() {
        }

        @Override
        public int compare(IdentityProviderModel idp1, IdentityProviderModel idp2) {
            return idp1.getAlias().compareTo(idp2.getAlias());
        }
    }
}

