/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.utils;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.representations.idm.OrganizationDomainRepresentation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.utils.StringUtil;

public class Organizations {
    public static boolean canManageOrganizationGroup(KeycloakSession session, GroupModel group) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            Object organization = session.getAttribute(OrganizationModel.class.getName());
            if (organization != null) {
                return true;
            }
            String orgId = group.getFirstAttribute("kc.org");
            return StringUtil.isBlank((String)orgId);
        }
        return true;
    }

    public static List<IdentityProviderModel> resolveBroker(KeycloakSession session, UserModel user) {
        OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        RealmModel realm = session.getContext().getRealm();
        OrganizationModel organization = provider.getByMember(user);
        if (organization == null || !organization.isEnabled()) {
            return List.of();
        }
        if (provider.isManagedMember(organization, user)) {
            List organizationBrokers = organization.getIdentityProviders().toList();
            return session.users().getFederatedIdentitiesStream(realm, user).map(f -> {
                IdentityProviderModel broker = realm.getIdentityProviderByAlias(f.getIdentityProvider());
                if (!organizationBrokers.contains(broker)) {
                    return null;
                }
                FederatedIdentityModel identity = session.users().getFederatedIdentity(realm, user, broker.getAlias());
                if (identity != null) {
                    return broker;
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    public static Consumer<GroupModel> removeGroup(KeycloakSession session, RealmModel realm) {
        return group -> {
            if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
                realm.removeGroup(group);
                return;
            }
            OrganizationModel current = (OrganizationModel)session.getAttribute(OrganizationModel.class.getName());
            try {
                String orgId = group.getFirstAttribute("kc.org");
                OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
                if (orgId != null) {
                    session.setAttribute(OrganizationModel.class.getName(), (Object)provider.getById(orgId));
                }
                realm.removeGroup(group);
            }
            finally {
                if (current == null) {
                    session.removeAttribute(OrganizationModel.class.getName());
                } else {
                    session.setAttribute(OrganizationModel.class.getName(), (Object)current);
                }
            }
        };
    }

    public static boolean isEnabledAndOrganizationsPresent(OrganizationProvider orgProvider) {
        return orgProvider != null && orgProvider.isEnabled() && orgProvider.count() != 0L;
    }

    public static void checkEnabled(OrganizationProvider provider) {
        if (provider == null || !provider.isEnabled()) {
            throw ErrorResponse.error("Organizations not enabled for this realm.", Response.Status.NOT_FOUND);
        }
    }

    public static OrganizationRepresentation toRepresentation(OrganizationModel model) {
        if (model == null) {
            return null;
        }
        OrganizationRepresentation rep = new OrganizationRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getName());
        rep.setEnabled(model.isEnabled());
        rep.setDescription(model.getDescription());
        rep.setAttributes(model.getAttributes());
        model.getDomains().filter(Objects::nonNull).map(Organizations::toRepresentation).forEach(arg_0 -> ((OrganizationRepresentation)rep).addDomain(arg_0));
        return rep;
    }

    public static OrganizationDomainRepresentation toRepresentation(OrganizationDomainModel model) {
        OrganizationDomainRepresentation representation = new OrganizationDomainRepresentation();
        representation.setName(model.getName());
        representation.setVerified(model.isVerified());
        return representation;
    }

    public static OrganizationModel toModel(OrganizationRepresentation rep, OrganizationModel model) {
        if (rep == null) {
            return null;
        }
        model.setName(rep.getName());
        model.setEnabled(rep.isEnabled());
        model.setDescription(rep.getDescription());
        model.setAttributes(rep.getAttributes());
        model.setDomains(Optional.ofNullable(rep.getDomains()).orElse(Set.of()).stream().filter(Objects::nonNull).filter(domain -> StringUtil.isNotBlank((String)domain.getName())).map(Organizations::toModel).collect(Collectors.toSet()));
        return model;
    }

    public static OrganizationDomainModel toModel(OrganizationDomainRepresentation domainRepresentation) {
        return new OrganizationDomainModel(domainRepresentation.getName(), domainRepresentation.isVerified());
    }

    public static InviteOrgActionToken parseInvitationToken(HttpRequest request) throws VerificationException {
        MultivaluedMap queryParameters = request.getUri().getQueryParameters();
        String tokenFromQuery = (String)queryParameters.getFirst((Object)"token");
        if (tokenFromQuery == null) {
            return null;
        }
        return (InviteOrgActionToken)TokenVerifier.create((String)tokenFromQuery, InviteOrgActionToken.class).getToken();
    }
}

