/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.OID4VCClientRegistrationProvider;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialIssuer;
import org.keycloak.protocol.oid4vc.model.Format;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.services.Urls;
import org.keycloak.urls.UrlType;
import org.keycloak.wellknown.WellKnownProvider;

public class OID4VCIssuerWellKnownProvider
implements WellKnownProvider {
    private final KeycloakSession keycloakSession;

    public OID4VCIssuerWellKnownProvider(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    public void close() {
    }

    @Override
    public Object getConfig() {
        return new CredentialIssuer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext())).setCredentialEndpoint(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(this.keycloakSession.getContext())).setCredentialsSupported(OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.keycloakSession)).setAuthorizationServers(List.of(OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext())));
    }

    public static Map<String, SupportedCredentialConfiguration> getSupportedCredentials(KeycloakSession keycloakSession) {
        RealmModel realm = keycloakSession.getContext().getRealm();
        List<Format> supportedFormats = realm.getComponentsStream(realm.getId(), VerifiableCredentialsSigningService.class.getName()).map(cm -> keycloakSession.getKeycloakSessionFactory().getProviderFactory(VerifiableCredentialsSigningService.class, cm.getProviderId())).filter(VCSigningServiceProviderFactory.class::isInstance).map(VCSigningServiceProviderFactory.class::cast).map(VCSigningServiceProviderFactory::supportedFormat).toList();
        return keycloakSession.getContext().getRealm().getClientsStream().filter(cm -> cm.getProtocol() != null).filter(cm -> cm.getProtocol().equals("oid4vc")).map(cm -> OID4VCClientRegistrationProvider.fromClientAttributes(cm.getClientId(), cm.getAttributes())).map(OID4VCClient::getSupportedVCTypes).flatMap(Collection::stream).filter(sc -> supportedFormats.contains((Object)sc.getFormat())).distinct().collect(Collectors.toMap(SupportedCredentialConfiguration::getId, sc -> sc, (sc1, sc2) -> sc1));
    }

    public static String getIssuer(KeycloakContext context) {
        KeycloakUriInfo frontendUriInfo = context.getUri(UrlType.FRONTEND);
        return Urls.realmIssuer(frontendUriInfo.getBaseUri(), context.getRealm().getName());
    }

    public static String getCredentialsEndpoint(KeycloakContext context) {
        return OID4VCIssuerWellKnownProvider.getIssuer(context) + "/protocol/oid4vc/credential";
    }
}

