/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import javax.ws.rs.Path;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceServerService;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.admin.RealmAuth;

public class AuthorizationService {
    private final RealmAuth auth;
    private final ClientModel client;
    private final KeycloakSession session;
    private final ResourceServer resourceServer;
    private final AuthorizationProvider authorization;

    public AuthorizationService(KeycloakSession session, ClientModel client, RealmAuth auth) {
        this.session = session;
        this.client = client;
        this.authorization = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        this.resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findByClient(this.client.getId());
        this.auth = auth;
        if (auth != null) {
            this.auth.init(RealmAuth.Resource.AUTHORIZATION);
        }
    }

    @Path(value="/resource-server")
    public ResourceServerService resourceServer() {
        ResourceServerService resource = new ResourceServerService(this.authorization, this.resourceServer, this.client, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    public void enable() {
        if (!this.isEnabled()) {
            this.resourceServer().create();
        }
    }

    public void disable() {
        if (this.isEnabled()) {
            this.resourceServer().delete();
        }
    }

    public boolean isEnabled() {
        return this.resourceServer != null;
    }
}

