/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ServicesLogger;

public class ClientAuthenticationFlow
implements AuthenticationFlow {
    private static final Logger logger = Logger.getLogger(ClientAuthenticationFlow.class);
    Response alternativeChallenge = null;
    AuthenticationProcessor processor;
    AuthenticationFlowModel flow;

    public ClientAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
    }

    public Response processAction(String actionExecution) {
        throw new IllegalStateException("Not supposed to be invoked");
    }

    public Response processFlow() {
        List<AuthenticationExecutionModel> executions = this.findExecutionsToRun();
        for (AuthenticationExecutionModel model : executions) {
            ClientAuthenticatorFactory factory = (ClientAuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new AuthenticationFlowException("Could not find ClientAuthenticatorFactory for: " + model.getAuthenticator(), AuthenticationFlowError.INTERNAL_ERROR);
            }
            ClientAuthenticator authenticator = factory.create();
            logger.debugv("client authenticator: {0}", (Object)factory.getId());
            AuthenticationProcessor.Result context = this.processor.createClientAuthenticatorContext(model, authenticator, executions);
            authenticator.authenticateClient((ClientAuthenticationFlowContext)context);
            ClientModel client = this.processor.getClient();
            if (client == null) continue;
            String expectedClientAuthType = client.getClientAuthenticatorType();
            if (expectedClientAuthType == null) {
                expectedClientAuthType = KeycloakModelUtils.getDefaultClientAuthenticatorType();
                ServicesLogger.LOGGER.authMethodFallback(client.getClientId(), expectedClientAuthType);
            }
            if (!factory.getId().equals(expectedClientAuthType)) continue;
            Response response = this.processResult(context);
            if (response != null) {
                return response;
            }
            if (!context.getStatus().equals((Object)FlowStatus.SUCCESS)) {
                throw new AuthenticationFlowException("Expected success, but for an unknown reason the status was " + context.getStatus(), AuthenticationFlowError.INTERNAL_ERROR);
            }
            logger.debugv("Client {0} authenticated by {1}", (Object)client.getClientId(), (Object)factory.getId());
            this.processor.getEvent().detail("client_auth_method", factory.getId());
            return null;
        }
        if (this.alternativeChallenge != null) {
            this.processor.getEvent().error("invalid_client");
            return this.alternativeChallenge;
        }
        throw new AuthenticationFlowException("Client was not identified by any client authenticator", AuthenticationFlowError.UNKNOWN_CLIENT);
    }

    protected List<AuthenticationExecutionModel> findExecutionsToRun() {
        List executions = this.processor.getRealm().getAuthenticationExecutions(this.flow.getId());
        List<AuthenticationExecutionModel> executionsToRun = new ArrayList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionModel execution : executions) {
            if (execution.isRequired()) {
                executionsToRun = Arrays.asList(execution);
                break;
            }
            if (!execution.isAlternative()) continue;
            executionsToRun.add(execution);
        }
        if (logger.isTraceEnabled()) {
            ArrayList<String> exIds = new ArrayList<String>();
            for (AuthenticationExecutionModel execution : executionsToRun) {
                exIds.add(execution.getId());
            }
            logger.tracef("Using executions for client authentication: %s", (Object)((Object)exIds).toString());
        }
        return executionsToRun;
    }

    protected Response processResult(AuthenticationProcessor.Result result) {
        AuthenticationExecutionModel execution = result.getExecution();
        FlowStatus status = result.getStatus();
        logger.debugv("client authenticator {0}: {1}", (Object)status.toString(), (Object)execution.getAuthenticator());
        if (status == FlowStatus.SUCCESS) {
            return null;
        }
        if (status == FlowStatus.FAILED) {
            if (result.getChallenge() != null) {
                return this.sendChallenge(result, execution);
            }
            throw new AuthenticationFlowException(result.getError());
        }
        if (status == FlowStatus.FORCE_CHALLENGE) {
            return this.sendChallenge(result, execution);
        }
        if (status == FlowStatus.CHALLENGE) {
            if (this.alternativeChallenge == null) {
                this.alternativeChallenge = result.getChallenge();
            }
            return this.sendChallenge(result, execution);
        }
        if (status == FlowStatus.FAILURE_CHALLENGE) {
            return this.sendChallenge(result, execution);
        }
        ServicesLogger.LOGGER.unknownResultStatus();
        throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticationProcessor.Result result, AuthenticationExecutionModel execution) {
        logger.debugv("client authenticator: sending challenge for authentication execution {0}", (Object)execution.getAuthenticator());
        if (result.getError() != null) {
            String errorAsString = result.getError().toString().toLowerCase();
            result.getEvent().error(errorAsString);
        } else if (result.getClient() == null) {
            result.getEvent().error("invalid_client");
        } else {
            result.getEvent().error("invalid_client_credentials");
        }
        return result.getChallenge();
    }
}

