/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.representations.JsonWebToken;

public class DefaultActionTokenKey
extends JsonWebToken
implements ActionTokenKeyModel {
    public static final String ACTION_TOKEN_USER_ID = "ACTION_TOKEN_USER";
    public static final String JSON_FIELD_ACTION_VERIFICATION_NONCE = "nonce";
    @JsonProperty(value="nonce", required=true)
    private UUID actionVerificationNonce;

    public DefaultActionTokenKey(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce) {
        this.subject = userId;
        this.type = actionId;
        this.expiration = absoluteExpirationInSecs;
        this.actionVerificationNonce = actionVerificationNonce == null ? UUID.randomUUID() : actionVerificationNonce;
    }

    @JsonIgnore
    public String getUserId() {
        return this.getSubject();
    }

    @JsonIgnore
    public String getActionId() {
        return this.getType();
    }

    public UUID getActionVerificationNonce() {
        return this.actionVerificationNonce;
    }

    public String serializeKey() {
        return String.format("%s.%d.%s.%s", this.getUserId(), this.getExpiration(), this.getActionVerificationNonce(), this.getActionId());
    }

    public static DefaultActionTokenKey from(String serializedKey) {
        if (serializedKey == null) {
            return null;
        }
        String[] parsed = serializedKey.split("\\.", 4);
        if (parsed.length != 4) {
            return null;
        }
        return new DefaultActionTokenKey(parsed[0], parsed[3], Integer.parseInt(parsed[1]), UUID.fromString(parsed[2]));
    }
}

