/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.resetcred;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.actiontoken.resetcred.ResetCredentialsActionToken;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.ServicesLogger;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ResetCredentialEmail
implements Authenticator,
AuthenticatorFactory {
    private static final Logger logger = Logger.getLogger(ResetCredentialEmail.class);
    public static final String PROVIDER_ID = "reset-credential-email";
    public static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED};

    public void authenticate(AuthenticationFlowContext context) {
        UserModel user = context.getUser();
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        String username = authenticationSession.getAuthNote("ATTEMPTED_USERNAME");
        if (user == null) {
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
            return;
        }
        String actionTokenUserId = authenticationSession.getAuthNote("ACTION_TOKEN_USER");
        if (actionTokenUserId != null && Objects.equals(user.getId(), actionTokenUserId)) {
            logger.debugf("Forget-password triggered when reauthenticating user after authentication via action token. Skipping reset-credential-email screen and using user '%s' ", (Object)user.getUsername());
            context.success();
            return;
        }
        EventBuilder event = context.getEvent();
        if (user.getEmail() == null || user.getEmail().trim().length() == 0) {
            event.user(user).detail("username", username).error("invalid_email");
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
            return;
        }
        int validityInSecs = context.getRealm().getActionTokenGeneratedByUserLifespan();
        int absoluteExpirationInSecs = Time.currentTime() + validityInSecs;
        ResetCredentialsActionToken token = new ResetCredentialsActionToken(user.getId(), absoluteExpirationInSecs, authenticationSession.getId());
        String link = UriBuilder.fromUri((URI)context.getActionTokenUrl(token.serialize(context.getSession(), context.getRealm(), context.getUriInfo()))).build(new Object[0]).toString();
        long expirationInMinutes = TimeUnit.SECONDS.toMinutes(validityInSecs);
        try {
            ((EmailTemplateProvider)context.getSession().getProvider(EmailTemplateProvider.class)).setRealm(context.getRealm()).setUser(user).sendPasswordReset(link, expirationInMinutes);
            event.clone().event(EventType.SEND_RESET_PASSWORD).user(user).detail("username", username).detail("email", user.getEmail()).detail("code_id", authenticationSession.getId()).success();
            context.forkWithSuccessMessage(new FormMessage("emailSentMessage", new Object[0]));
        }
        catch (EmailException e) {
            event.clone().event(EventType.SEND_RESET_PASSWORD).detail("username", username).user(user).error("email_send_failed");
            ServicesLogger.LOGGER.failedToSendPwdResetEmail(e);
            Response challenge = context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage();
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, challenge);
        }
    }

    public static Long getLastChangedTimestamp(KeycloakSession session, RealmModel realm, UserModel user) {
        PasswordCredentialProvider passwordProvider = (PasswordCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-password");
        CredentialModel password = passwordProvider.getPassword(realm, user);
        return password == null ? null : password.getCreatedDate();
    }

    public void action(AuthenticationFlowContext context) {
        context.getUser().setEmailVerified(true);
        context.success();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public String getDisplayType() {
        return "Send Reset Email";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Send email to user and wait for response.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void close() {
    }

    public Authenticator create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

