/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.representations.JsonWebToken;

public abstract class AbstractClaimMapper
extends AbstractIdentityProviderMapper {
    public static final String CLAIM = "claim";
    public static final String CLAIM_VALUE = "claim.value";

    public static Object getClaimValue(JsonWebToken token, String claim) {
        String[] split = claim.split("\\.");
        Map jsonObject = token.getOtherClaims();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                return jsonObject.get(split[i]);
            }
            Object val = jsonObject.get(split[i]);
            if (!(val instanceof Map)) {
                return null;
            }
            jsonObject = (Map)val;
        }
        return null;
    }

    public static Object getClaimValue(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String claim = (String)mapperModel.getConfig().get(CLAIM);
        return AbstractClaimMapper.getClaimValue(context, claim);
    }

    public static Object getClaimValue(BrokeredIdentityContext context, String claim) {
        Object value;
        JsonWebToken token = (JsonWebToken)context.getContextData().get("VALIDATED_ACCESS_TOKEN");
        if (token != null && (value = AbstractClaimMapper.getClaimValue(token, claim)) != null) {
            return value;
        }
        token = (JsonWebToken)context.getContextData().get("VALIDATED_ID_TOKEN");
        if (token != null && (value = AbstractClaimMapper.getClaimValue(token, claim)) != null) {
            return value;
        }
        JsonNode profileJsonNode = (JsonNode)context.getContextData().get("UserInfo");
        value = AbstractJsonUserAttributeMapper.getJsonValue(profileJsonNode, claim);
        if (value != null) {
            return value;
        }
        return null;
    }

    protected boolean hasClaimValue(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Object value = AbstractClaimMapper.getClaimValue(mapperModel, context);
        String desiredValue = (String)mapperModel.getConfig().get(CLAIM_VALUE);
        return this.valueEquals(desiredValue, value);
    }

    public boolean valueEquals(String desiredValue, Object value) {
        if (value instanceof String) {
            if (desiredValue.equals(value)) {
                return true;
            }
        } else if (value instanceof Double) {
            try {
                if (Double.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception exception) {}
        } else if (value instanceof Integer) {
            try {
                if (Integer.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception exception) {}
        } else if (value instanceof Boolean) {
            try {
                if (Boolean.valueOf(desiredValue).equals(value)) {
                    return true;
                }
            }
            catch (Exception exception) {}
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object val : list) {
                if (!this.valueEquals(desiredValue, val)) continue;
                return true;
            }
        }
        return false;
    }
}

