/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.installation;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.oidc.installation.KeycloakOIDCClientInstallation;

public class KeycloakOIDCJbossSubsystemClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<secure-deployment name=\"WAR MODULE NAME.war\">\n");
        buffer.append("    <realm>").append(realm.getName()).append("</realm>\n");
        buffer.append("    <auth-server-url>").append(baseUri.toString()).append("</auth-server-url>\n");
        if (client.isBearerOnly()) {
            buffer.append("    <bearer-only>true</bearer-only>\n");
        } else if (client.isPublicClient()) {
            buffer.append("    <public-client>true</public-client>\n");
        }
        buffer.append("    <ssl-required>").append(realm.getSslRequired().name()).append("</ssl-required>\n");
        buffer.append("    <resource>").append(client.getClientId()).append("</resource>\n");
        String cred = client.getSecret();
        if (KeycloakOIDCClientInstallation.showClientCredentialsAdapterConfig(client)) {
            Map<String, Object> adapterConfig = KeycloakOIDCClientInstallation.getClientCredentialsAdapterConfig(session, client);
            for (Map.Entry<String, Object> entry : adapterConfig.entrySet()) {
                buffer.append("    <credential name=\"" + entry.getKey() + "\">");
                Object value = entry.getValue();
                if (value instanceof Map) {
                    buffer.append("\n");
                    Map asMap = (Map)value;
                    for (Map.Entry credEntry : asMap.entrySet()) {
                        buffer.append("        <" + (String)credEntry.getKey() + ">" + credEntry.getValue().toString() + "</" + (String)credEntry.getKey() + ">\n");
                    }
                    buffer.append("    </credential>\n");
                    continue;
                }
                buffer.append(value.toString()).append("</credential>\n");
            }
        }
        if (client.getRoles().size() > 0) {
            buffer.append("    <use-resource-role-mappings>true</use-resource-role-mappings>\n");
        }
        buffer.append("</secure-deployment>\n");
        return Response.ok((Object)buffer.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "openid-connect";
    }

    public String getDisplayType() {
        return "Keycloak OIDC JBoss Subsystem XML";
    }

    public String getHelpText() {
        return "XML snippet you must edit and add to the Keycloak OIDC subsystem on your client app server.  This type of configuration is useful when you can't or don't want to crack open your WAR file.";
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-oidc-jboss-subsystem";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public String getFilename() {
        return "keycloak-oidc-subsystem.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }
}

