/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.models.ClaimMask;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.managers.RealmManager;

public class DefaultMigrationProvider
implements MigrationProvider {
    private final KeycloakSession session;

    public DefaultMigrationProvider(KeycloakSession session) {
        this.session = session;
    }

    public List<ProtocolMapperRepresentation> getMappersForClaimMask(Long claimMask) {
        Map<String, ProtocolMapperRepresentation> allMappers = DefaultMigrationProvider.getAllDefaultMappers(this.session);
        if (claimMask == null) {
            return new ArrayList<ProtocolMapperRepresentation>(allMappers.values());
        }
        if (!ClaimMask.hasUsername((long)claimMask)) {
            allMappers.remove("username");
        }
        if (!ClaimMask.hasEmail((long)claimMask)) {
            allMappers.remove("email");
        }
        if (!ClaimMask.hasName((long)claimMask)) {
            allMappers.remove("family name");
            allMappers.remove("full name");
            allMappers.remove("given name");
        }
        return new ArrayList<ProtocolMapperRepresentation>(allMappers.values());
    }

    public List<ProtocolMapperModel> getBuiltinMappers(String protocol) {
        LoginProtocolFactory providerFactory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        return providerFactory.getBuiltinMappers();
    }

    public void setupAdminCli(RealmModel realm) {
        new RealmManager(this.session).setupAdminCli(realm);
    }

    public void close() {
    }

    private static Map<String, ProtocolMapperRepresentation> getAllDefaultMappers(KeycloakSession session) {
        HashMap<String, ProtocolMapperRepresentation> allMappers = new HashMap<String, ProtocolMapperRepresentation>();
        List loginProtocolFactories = session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class);
        for (ProviderFactory factory : loginProtocolFactories) {
            LoginProtocolFactory loginProtocolFactory = (LoginProtocolFactory)factory;
            List currentMappers = loginProtocolFactory.getDefaultBuiltinMappers();
            for (ProtocolMapperModel protocolMapper : currentMappers) {
                ProtocolMapperRepresentation rep = ModelToRepresentation.toRepresentation((ProtocolMapperModel)protocolMapper);
                allMappers.put(protocolMapper.getName(), rep);
            }
        }
        return allMappers;
    }
}

