/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientTemplateResource {
    protected static final Logger logger = Logger.getLogger(ClientTemplateResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected ClientTemplateModel template;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;

    public ClientTemplateResource(RealmModel realm, AdminPermissionEvaluator auth, ClientTemplateModel template, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.template = template;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT_TEMPLATE);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.template);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.template);
        ProtocolMappersResource mappers = new ProtocolMappersResource(this.realm, (ProtocolMapperContainerModel)this.template, this.auth, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)mappers);
        return mappers;
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.template);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.template);
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.template, this.session, this.adminEvent, manageCheck, viewCheck);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ClientTemplateRepresentation rep) {
        this.auth.clients().requireManageTemplates();
        try {
            RepresentationToModel.updateClientTemplate((ClientTemplateRepresentation)rep, (ClientTemplateModel)this.template);
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client Template " + rep.getName() + " already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientTemplateRepresentation getClient() {
        this.auth.clients().requireView(this.template);
        return ModelToRepresentation.toRepresentation((ClientTemplateModel)this.template);
    }

    @DELETE
    @NoCache
    public Response deleteClientTemplate() {
        this.auth.clients().requireManage(this.template);
        try {
            this.realm.removeClientTemplate(this.template.getId());
            this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
            return Response.noContent().build();
        }
        catch (ModelException me) {
            return ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }
}

