/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.ClientRoleMappingsResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class RoleMapperResource {
    protected static final Logger logger = Logger.getLogger(RoleMapperResource.class);
    protected RealmModel realm;
    private RoleMapperModel roleMapper;
    private AdminEventBuilder adminEvent;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    private AdminPermissionEvaluator auth;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public RoleMapperResource(RealmModel realm, AdminPermissionEvaluator auth, RoleMapperModel roleMapper, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.REALM_ROLE_MAPPING);
        this.roleMapper = roleMapper;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getRoleMappings() {
        List clients;
        this.viewPermission.require();
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = this.roleMapper.getRealmRoleMappings();
        RealmManager manager = new RealmManager(this.session);
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((clients = this.realm.getClients()).size() > 0) {
            HashMap<String, ClientMappingsRepresentation> appMappings = new HashMap<String, ClientMappingsRepresentation>();
            for (ClientModel client : clients) {
                Set roleMappings = this.roleMapper.getClientRoleMappings(client);
                if (roleMappings.size() <= 0) continue;
                ClientMappingsRepresentation mappings = new ClientMappingsRepresentation();
                mappings.setId(client.getId());
                mappings.setClient(client.getClientId());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toRepresentation((RoleModel)role));
                }
                appMappings.put(client.getClientId(), mappings);
                all.setClientMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmRoleMappings() {
        this.viewPermission.require();
        Set realmMappings = this.roleMapper.getRealmRoleMappings();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmRoleMappings() {
        this.viewPermission.require();
        Set roles = this.realm.getRoles();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.roleMapper.hasRole(roleModel)) continue;
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmRoleMappings() {
        this.viewPermission.require();
        Set available = this.realm.getRoles();
        Set<RoleModel> set = available.stream().filter(r -> this.canMapRole((RoleModel)r)).collect(Collectors.toSet());
        return ClientRoleMappingsResource.getAvailableRoles(this.roleMapper, set);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmRoleMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            this.auth.roles().requireMapRole(roleModel);
            this.roleMapper.grantRole(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmRoleMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debug((Object)"deleteRealmRoleMappings");
        if (roles == null) {
            Set roleModels = this.roleMapper.getRealmRoleMappings();
            roles = new LinkedList<RoleRepresentation>();
            for (RoleModel roleModel : roleModels) {
                this.auth.roles().requireMapRole(roleModel);
                this.roleMapper.deleteRoleMapping(roleModel);
                roles.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                try {
                    this.roleMapper.deleteRoleMapping(roleModel);
                }
                catch (ModelException me) {
                    Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
                    throw new ErrorResponseException(me.getMessage(), MessageFormat.format(messages.getProperty(me.getMessage(), me.getMessage()), me.getParameters()), Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }

    private boolean canMapRole(RoleModel roleModel) {
        return this.auth.roles().canMapRole(roleModel);
    }

    @Path(value="clients/{client}")
    public ClientRoleMappingsResource getUserClientRoleMappingsResource(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Client not found");
        }
        ClientRoleMappingsResource resource = new ClientRoleMappingsResource(this.uriInfo, this.session, this.realm, this.auth, this.roleMapper, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
        return resource;
    }
}

