/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.security.MessageDigest;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.OAuthErrorException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.TokenExchangeTo;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenIntrospectionEndpoint;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.TokenUtil;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private Map<String, String> clientAuthAttributes;
    private static final Pattern VALID_CODE_VERIFIER_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-\\.~_]+$");
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Action action;
    private String grantType;

    public TokenEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
    }

    @POST
    public Response build() {
        this.formParams = this.request.getDecodedFormParameters();
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        this.checkClient();
        switch (this.action) {
            case AUTHORIZATION_CODE: {
                return this.buildAuthorizationCodeAccessTokenResponse();
            }
            case REFRESH_TOKEN: {
                return this.buildRefreshToken();
            }
            case PASSWORD: {
                return this.buildResourceOwnerPasswordCredentialsGrant();
            }
            case CLIENT_CREDENTIALS: {
                return this.buildClientCredentialsGrant();
            }
            case TOKEN_EXCHANGE: {
                return this.buildTokenExchange();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    @Path(value="introspect")
    public Object introspect() {
        TokenIntrospectionEndpoint tokenIntrospectionEndpoint = new TokenIntrospectionEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenIntrospectionEndpoint);
        return tokenIntrospectionEndpoint;
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        if (this.client.isBearerOnly()) {
            throw new ErrorResponseException("invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            throw new ErrorResponseException("invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
        }
        if (this.grantType.equals("authorization_code")) {
            this.event.event(EventType.CODE_TO_TOKEN);
            this.action = Action.AUTHORIZATION_CODE;
        } else if (this.grantType.equals("refresh_token")) {
            this.event.event(EventType.REFRESH_TOKEN);
            this.action = Action.REFRESH_TOKEN;
        } else if (this.grantType.equals("password")) {
            this.event.event(EventType.LOGIN);
            this.action = Action.PASSWORD;
        } else if (this.grantType.equals("client_credentials")) {
            this.event.event(EventType.CLIENT_LOGIN);
            this.action = Action.CLIENT_CREDENTIALS;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:token-exchange")) {
            this.event.event(EventType.TOKEN_EXCHANGE);
            this.action = Action.TOKEN_EXCHANGE;
        } else {
            throw new ErrorResponseException("invalid_request", "Invalid grant_type", Response.Status.BAD_REQUEST);
        }
        this.event.detail("grant_type", this.grantType);
    }

    public Response buildAuthorizationCodeAccessTokenResponse() {
        ClientSessionCode.ParseResult<AuthenticatedClientSessionModel> parseResult;
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_request", "Missing parameter: code", Response.Status.BAD_REQUEST);
        }
        String[] parts = code.split("\\.");
        if (parts.length == 4) {
            this.event.detail("code_id", parts[2]);
        }
        if ((parseResult = ClientSessionCode.parseResult(code, this.session, this.realm, AuthenticatedClientSessionModel.class)).isAuthSessionNotFound() || parseResult.isIllegalHash()) {
            this.event.error("invalid_code");
            AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
            if (clientSession != null) {
                clientSession.setUserSession(null);
            }
            throw new ErrorResponseException("invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
        if (!parseResult.getCode().isValid(CommonClientSessionModel.Action.CODE_TO_TOKEN.name(), ClientSessionCode.ActionType.CLIENT)) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        parseResult.getCode().setAction(null);
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new ErrorResponseException("invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        this.event.session(userSession.getId());
        String redirectUri = clientSession.getNote("redirect_uri");
        String formParam = (String)this.formParams.getFirst((Object)"redirect_uri");
        if (redirectUri != null && !redirectUri.equals(formParam)) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!this.client.isStandardFlowEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed to exchange code", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        String codeVerifier = (String)this.formParams.getFirst((Object)"code_verifier");
        String codeChallenge = clientSession.getNote("code_challenge");
        String codeChallengeMethod = clientSession.getNote("code_challenge_method");
        String authUserId = user.getId();
        String authUsername = user.getUsername();
        if (authUserId == null) {
            authUserId = "unknown";
        }
        if (authUsername == null) {
            authUsername = "unknown";
        }
        if (codeChallenge != null && codeVerifier == null) {
            logger.warnf("PKCE code verifier not specified, authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("code_verifier_missing");
            throw new ErrorResponseException("invalid_grant", "PKCE code verifier not specified", Response.Status.BAD_REQUEST);
        }
        if (codeChallenge != null) {
            if (!this.isValidPkceCodeVerifier(codeVerifier)) {
                logger.infof("PKCE invalid code verifier", new Object[0]);
                this.event.error("invalid_code_verifier");
                throw new ErrorResponseException("invalid_grant", "PKCE invalid code verifier", Response.Status.BAD_REQUEST);
            }
            logger.debugf("PKCE supporting Client, codeVerifier = %s", (Object)codeVerifier);
            String codeVerifierEncoded = codeVerifier;
            try {
                if (codeChallengeMethod != null && codeChallengeMethod.equals("S256")) {
                    logger.debugf("PKCE codeChallengeMethod = %s", (Object)codeChallengeMethod);
                    codeVerifierEncoded = this.generateS256CodeChallenge(codeVerifier);
                } else {
                    logger.debug((Object)"PKCE codeChallengeMethod is plain");
                    codeVerifierEncoded = codeVerifier;
                }
            }
            catch (Exception nae) {
                logger.infof("PKCE code verification failed, not supported algorithm specified", new Object[0]);
                this.event.error("pkce_verification_failed");
                throw new ErrorResponseException("invalid_grant", "PKCE code verification failed, not supported algorithm specified", Response.Status.BAD_REQUEST);
            }
            if (!codeChallenge.equals(codeVerifierEncoded)) {
                logger.warnf("PKCE verification failed. authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
                this.event.error("pkce_verification_failed");
                throw new ErrorResponseException("invalid_grant", "PKCE verification failed", Response.Status.BAD_REQUEST);
            }
            logger.debugf("PKCE verification success. codeVerifierEncoded = %s, codeChallenge = %s", (Object)codeVerifierEncoded, (Object)codeChallenge);
        }
        this.updateClientSession(clientSession);
        this.updateUserSessionFromClientAuth(userSession);
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, parseResult.getCode().getRequestedRoles(), this.realm, this.client, user, userSession, clientSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).accessToken(token).generateRefreshToken();
        String scopeParam = clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildRefreshToken() {
        AccessTokenResponse res;
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new ErrorResponseException("invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            TokenManager.RefreshResult result = this.tokenManager.refreshAccessToken(this.session, this.uriInfo, this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers);
            res = result.getResponse();
            if (!result.isOfflineToken()) {
                UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
                AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)userSession.getAuthenticatedClientSessions().get(this.client.getId());
                this.updateClientSession(clientSession);
                this.updateUserSessionFromClientAuth(userSession);
            }
        }
        catch (OAuthErrorException e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
            this.event.error("invalid_token");
            throw new ErrorResponseException(e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void updateClientSession(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            this.event.detail("client_session_state", adapterSessionId);
            String oldClientSessionState = clientSession.getNote("client_session_state");
            if (!adapterSessionId.equals(oldClientSessionState)) {
                clientSession.setNote("client_session_state", adapterSessionId);
            }
            this.event.detail("client_session_host", adapterSessionHost);
            String oldClientSessionHost = clientSession.getNote("client_session_host");
            if (!Objects.equals(adapterSessionHost, oldClientSessionHost)) {
                clientSession.setNote("client_session_host", adapterSessionHost);
            }
        }
    }

    private void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    public Response buildResourceOwnerPasswordCredentialsGrant() {
        this.event.detail("auth_method", "oauth_credentials");
        if (!this.client.isDirectAccessGrantsEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed for direct access grants", Response.Status.BAD_REQUEST);
        }
        if (this.client.isConsentRequired()) {
            this.event.error("consent_denied");
            throw new ErrorResponseException("invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, this.client, false);
        authSession.setProtocol("openid-connect");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        AuthenticationFlowModel flow = this.realm.getDirectGrantFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        Response challenge = processor.authenticateOnly();
        if (challenge != null) {
            return challenge;
        }
        processor.evaluateRequiredActionTriggers();
        UserModel user = authSession.getAuthenticatedUser();
        if (user.getRequiredActions() != null && user.getRequiredActions().size() > 0) {
            this.event.error("resolve_required_actions");
            throw new ErrorResponseException("invalid_grant", "Account is not fully set up", Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.setRolesAndMappersInSession(authSession);
        AuthenticatedClientSessionModel clientSession = processor.attachSession();
        UserSessionModel userSession = processor.getUserSession();
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken().generateRefreshToken();
        String scopeParam = clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildClientCredentialsGrant() {
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            clientUser = this.session.users().getServiceAccount(this.client);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, this.client, false);
        authSession.setAuthenticatedUser(clientUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        UserSessionModel userSession = this.session.sessions().createUserSession(authSession.getId(), this.realm, clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null);
        this.event.session(userSession);
        AuthenticationManager.setRolesAndMappersInSession(authSession);
        AuthenticatedClientSessionModel clientSession = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken().generateRefreshToken();
        String scopeParam = clientSession.getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildTokenExchange() {
        this.event.detail("auth_method", "oauth_credentials");
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        String subjectTokenType = (String)this.formParams.getFirst((Object)"subject_token_type");
        if (subjectTokenType != null && !subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(this.session, this.realm, this.uriInfo, this.clientConnection, true, true, false, subjectToken, this.headers);
        if (authResult == null) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "Invalid token", Response.Status.BAD_REQUEST);
        }
        String requestedIssuer = (String)this.formParams.getFirst((Object)"requested_issuer");
        if (requestedIssuer == null) {
            return this.exchangeClientToClient(authResult);
        }
        return this.exchangeToIdentityProvider(authResult, requestedIssuer);
    }

    public Response exchangeToIdentityProvider(AuthenticationManager.AuthResult authResult, String requestedIssuer) {
        IdentityProviderModel providerModel = this.realm.getIdentityProviderByAlias(requestedIssuer);
        if (providerModel == null) {
            this.event.error("unknown_identity_provider");
            throw new ErrorResponseException("invalid_request", "Invalid issuer", Response.Status.BAD_REQUEST);
        }
        IdentityProvider provider = IdentityBrokerService.getIdentityProvider(this.session, this.realm, requestedIssuer);
        if (!(provider instanceof TokenExchangeTo)) {
            this.event.error("unknown_identity_provider");
            throw new ErrorResponseException("invalid_request", "Issuer does not support token exchange", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, providerModel)) {
            logger.debug((Object)"Client not allowed to exchange for linked token");
            this.event.error("not_allowed");
            throw new ErrorResponseException("access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        Response response = ((TokenExchangeTo)provider).exchangeTo(this.uriInfo, this.client, authResult.getSession(), authResult.getUser(), authResult.getToken(), this.formParams);
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response exchangeClientToClient(AuthenticationManager.AuthResult subject) {
        String scopeParam;
        String requestedTokenType = (String)this.formParams.getFirst((Object)"requested_token_type");
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
        } else if (!requestedTokenType.equals("urn:ietf:params:oauth:token-type:access_token") && !requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token")) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("unsupported_requested_token_type", "Unsupported requested token type", Response.Status.BAD_REQUEST);
        }
        String audience = (String)this.formParams.getFirst((Object)"audience");
        if (audience == null) {
            this.event.error("invalid_request");
            throw new ErrorResponseException("invalid_audience", "Audience parameter required", Response.Status.BAD_REQUEST);
        }
        ClientModel targetClient = null;
        if (audience != null) {
            targetClient = this.realm.getClientByClientId(audience);
        }
        if (targetClient == null) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("invalid_client", "Client authentication ended, but client is null", Response.Status.BAD_REQUEST);
        }
        if (targetClient.isConsentRequired()) {
            this.event.error("consent_denied");
            throw new ErrorResponseException("invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).clients().canExchangeTo(this.client, targetClient)) {
            logger.debug((Object)"Client does not have exchange rights for target audience");
            this.event.error("not_allowed");
            throw new ErrorResponseException("access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        AuthenticationSessionModel authSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, targetClient, false);
        authSession.setAuthenticatedUser(subject.getUser());
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        UserSessionModel userSession = subject.getSession();
        this.event.session(userSession);
        AuthenticationManager.setRolesAndMappersInSession(authSession);
        AuthenticatedClientSessionModel clientSession = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, targetClient, this.event, this.session, userSession, clientSession).generateAccessToken();
        responseBuilder.getAccessToken().issuedFor(this.client.getClientId());
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token")) {
            responseBuilder.generateRefreshToken();
            responseBuilder.getRefreshToken().issuedFor(this.client.getClientId());
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSession.getNote("scope")))) {
            responseBuilder.generateIDToken();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.uriInfo, this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private boolean isValidPkceCodeVerifier(String codeVerifier) {
        if (codeVerifier.length() < 43) {
            logger.infof(" Error: PKCE codeVerifier length under lower limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        if (codeVerifier.length() > 128) {
            logger.infof(" Error: PKCE codeVerifier length over upper limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        Matcher m = VALID_CODE_VERIFIER_PATTERN.matcher(codeVerifier);
        return m.matches();
    }

    private String generateS256CodeChallenge(String codeVerifier) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(codeVerifier.getBytes("ISO_8859_1"));
        byte[] digestBytes = md.digest();
        String codeVerifierEncoded = Base64Url.encode((byte[])digestBytes);
        return codeVerifierEncoded;
    }

    private static enum Action {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        PASSWORD,
        CLIENT_CREDENTIALS,
        TOKEN_EXCHANGE;

    }
}

