/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.requiredactions.UpdatePassword;
import org.keycloak.credential.CredentialInput;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.services.validation.Validation;

public class ConsoleUpdatePassword
extends UpdatePassword
implements RequiredActionProvider {
    public static final ConsoleUpdatePassword SINGLETON = new ConsoleUpdatePassword();
    private static final Logger logger = Logger.getLogger(ConsoleUpdatePassword.class);
    public static final String PASSWORD_NEW = "password-new";
    public static final String PASSWORD_CONFIRM = "password-confirm";

    protected ConsoleDisplayMode challenge(RequiredActionContext context) {
        return ConsoleDisplayMode.challenge((RequiredActionContext)context).header().param(PASSWORD_NEW).label("console-new-password").mask(true).param(PASSWORD_CONFIRM).label("console-confirm-password").mask(true).challenge();
    }

    @Override
    public void requiredActionChallenge(RequiredActionContext context) {
        context.challenge(this.challenge(context).message("console-update-password", new String[0]));
    }

    @Override
    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        event.event(EventType.UPDATE_PASSWORD);
        String passwordNew = (String)formData.getFirst((Object)PASSWORD_NEW);
        String passwordConfirm = (String)formData.getFirst((Object)PASSWORD_CONFIRM);
        EventBuilder errorEvent = event.clone().event(EventType.UPDATE_PASSWORD_ERROR).client(context.getAuthenticationSession().getClient()).user(context.getAuthenticationSession().getAuthenticatedUser());
        if (Validation.isBlank(passwordNew)) {
            context.challenge(this.challenge(context).message("missingPasswordMessage", new String[0]));
            errorEvent.error("password_missing");
            return;
        }
        if (!passwordNew.equals(passwordConfirm)) {
            context.challenge(this.challenge(context).message("notMatchPasswordMessage", new String[0]));
            errorEvent.error("password_confirm_error");
            return;
        }
        try {
            context.getSession().userCredentialManager().updateCredential(context.getRealm(), context.getUser(), (CredentialInput)UserCredentialModel.password((String)passwordNew, (boolean)false));
            context.success();
        }
        catch (ModelException me) {
            errorEvent.detail("reason", me.getMessage()).error("password_rejected");
            context.challenge(this.challenge(context).text(me.getMessage()));
            return;
        }
        catch (Exception ape) {
            errorEvent.detail("reason", ape.getMessage()).error("password_rejected");
            context.challenge(this.challenge(context).text(ape.getMessage()));
            return;
        }
    }
}

