/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.Failure;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;

public class ClientRegistrationAuth {
    private final KeycloakSession session;
    private final ClientRegistrationProvider provider;
    private final EventBuilder event;
    private RealmModel realm;
    private JsonWebToken jwt;
    private ClientInitialAccessModel initialAccessModel;
    private String kid;
    private String token;
    private String endpoint;

    public ClientRegistrationAuth(KeycloakSession session, ClientRegistrationProvider provider, EventBuilder event, String endpoint) {
        this.session = session;
        this.provider = provider;
        this.event = event;
        this.endpoint = endpoint;
    }

    private void init() {
        this.realm = this.session.getContext().getRealm();
        String authorizationHeader = (String)this.session.getContext().getRequestHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader == null) {
            return;
        }
        String[] split = authorizationHeader.split(" ");
        if (!split[0].equalsIgnoreCase("bearer")) {
            return;
        }
        this.token = split[1];
        ClientRegistrationTokenUtils.TokenVerification tokenVerification = ClientRegistrationTokenUtils.verifyToken(this.session, this.realm, this.token);
        if (tokenVerification.getError() != null) {
            throw this.unauthorized(tokenVerification.getError().getMessage());
        }
        this.kid = tokenVerification.getKid();
        this.jwt = tokenVerification.getJwt();
        if (this.isInitialAccessToken()) {
            this.initialAccessModel = this.session.realms().getClientInitialAccessModel(this.session.getContext().getRealm(), this.jwt.getId());
            if (this.initialAccessModel == null) {
                throw this.unauthorized("Initial Access Token not found");
            }
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getKid() {
        return this.kid;
    }

    public JsonWebToken getJwt() {
        return this.jwt;
    }

    private boolean isBearerToken() {
        return this.jwt != null && "Bearer".equals(this.jwt.getType());
    }

    public boolean isInitialAccessToken() {
        return this.jwt != null && "InitialAccessToken".equals(this.jwt.getType());
    }

    public boolean isRegistrationAccessToken() {
        return this.jwt != null && "RegistrationAccessToken".equals(this.jwt.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RegistrationAuth requireCreate(ClientRegistrationContext context) {
        this.init();
        RegistrationAuth registrationAuth = RegistrationAuth.ANONYMOUS;
        if (this.isBearerToken()) {
            this.checkClientProtocol();
            if (!this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.CREATE_CLIENT)) throw this.forbidden();
            registrationAuth = RegistrationAuth.AUTHENTICATED;
        } else if (this.isInitialAccessToken()) {
            if (this.initialAccessModel.getRemainingCount() <= 0) throw this.unauthorized("No remaining count on initial access token");
            if (this.initialAccessModel.getExpiration() != 0 && this.initialAccessModel.getTimestamp() + this.initialAccessModel.getExpiration() <= Time.currentTime()) throw this.unauthorized("Expired initial access token");
            registrationAuth = RegistrationAuth.AUTHENTICATED;
        }
        try {
            ClientRegistrationPolicyManager.triggerBeforeRegister(context, registrationAuth);
            return registrationAuth;
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw this.forbidden(crpe.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requireView(ClientModel client) {
        RegistrationAuth authType = null;
        boolean authenticated = false;
        this.init();
        if (this.isBearerToken()) {
            this.checkClientProtocol();
            if (!this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS)) throw this.forbidden();
            if (client == null) {
                throw this.notFound();
            }
            authenticated = true;
            authType = RegistrationAuth.AUTHENTICATED;
        } else if (this.isRegistrationAccessToken()) {
            if (client != null && client.getRegistrationToken() != null && client.getRegistrationToken().equals(this.jwt.getId())) {
                authenticated = true;
                authType = this.getRegistrationAuth();
            }
        } else {
            if (this.isInitialAccessToken()) {
                throw this.unauthorized("Not initial access token allowed");
            }
            if (this.authenticateClient(client)) {
                authenticated = true;
                authType = RegistrationAuth.AUTHENTICATED;
            }
        }
        if (!authenticated) throw this.unauthorized("Not authorized to view client. Not valid token or client credentials provided.");
        try {
            ClientRegistrationPolicyManager.triggerBeforeView(this.session, this.provider, authType, client);
            return;
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw this.forbidden(crpe.getMessage());
        }
    }

    public RegistrationAuth getRegistrationAuth() {
        String str = (String)this.jwt.getOtherClaims().get("registration_auth");
        return RegistrationAuth.fromString(str);
    }

    public RegistrationAuth requireUpdate(ClientRegistrationContext context, ClientModel client) {
        RegistrationAuth regAuth = this.requireUpdateAuth(client);
        try {
            ClientRegistrationPolicyManager.triggerBeforeUpdate(context, regAuth, client);
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw this.forbidden(crpe.getMessage());
        }
        return regAuth;
    }

    public void requireDelete(ClientModel client) {
        RegistrationAuth chainType = this.requireUpdateAuth(client);
        try {
            ClientRegistrationPolicyManager.triggerBeforeRemove(this.session, this.provider, chainType, client);
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw this.forbidden(crpe.getMessage());
        }
    }

    private void checkClientProtocol() {
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(this.jwt.getIssuedFor());
        this.checkClientProtocol(client);
    }

    private void checkClientProtocol(ClientModel client) {
        if ((this.endpoint.equals("openid-connect") || this.endpoint.equals("saml2-entity-descriptor")) && client != null && !this.endpoint.contains(client.getProtocol())) {
            throw new ErrorResponseException("invalid_client", "Wrong client protocol.", Response.Status.BAD_REQUEST);
        }
    }

    private RegistrationAuth requireUpdateAuth(ClientModel client) {
        this.init();
        if (this.isBearerToken()) {
            this.checkClientProtocol();
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS)) {
                if (client == null) {
                    throw this.notFound();
                }
                return RegistrationAuth.AUTHENTICATED;
            }
            throw this.forbidden();
        }
        if (this.isRegistrationAccessToken() && client != null && client.getRegistrationToken() != null && client.getRegistrationToken().equals(this.jwt.getId())) {
            return this.getRegistrationAuth();
        }
        throw this.unauthorized("Not authorized to update client. Maybe missing token or bad token type.");
    }

    public ClientInitialAccessModel getInitialAccessModel() {
        return this.initialAccessModel;
    }

    private boolean hasRole(String ... roles) {
        try {
            if (this.jwt.getIssuedFor().equals("admin-cli") || this.jwt.getIssuedFor().equals("security-admin-console")) {
                return this.hasRoleInModel(roles);
            }
            return this.hasRoleInToken(roles);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean hasRoleInModel(String[] roles) {
        UserModel user = this.session.users().getUserById(this.jwt.getSubject(), this.realm);
        if (user == null) {
            return false;
        }
        ClientModel roleNamespace = this.realm.getName().equals(Config.getAdminRealm()) ? this.realm.getMasterAdminClient() : this.realm.getClientByClientId("realm-management");
        for (String role : roles) {
            RoleModel roleModel = roleNamespace.getRole(role);
            if (!user.hasRole(roleModel)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRoleInToken(String[] role) {
        Map otherClaims = this.jwt.getOtherClaims();
        if (otherClaims != null) {
            Map resourceAccess = (Map)this.jwt.getOtherClaims().get("resource_access");
            if (resourceAccess == null) {
                return false;
            }
            List roles = null;
            Map map = this.realm.getName().equals(Config.getAdminRealm()) ? (Map)resourceAccess.get(this.realm.getMasterAdminClient().getClientId()) : (Map)resourceAccess.get("realm-management");
            if (map != null) {
                roles = (List)map.get("roles");
            }
            if (roles == null) {
                return false;
            }
            for (String r : role) {
                if (!roles.contains(r)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean authenticateClient(ClientModel client) {
        if (client == null) {
            return false;
        }
        if (client.isPublicClient()) {
            return true;
        }
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(this.session, this.event);
        Response response = processor.authenticateClient();
        if (response != null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("Failed to authenticate client");
        }
        ClientModel authClient = processor.getClient();
        if (authClient == null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("No client authenticated");
        }
        if (!authClient.getClientId().equals(client.getClientId())) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized("Different client authenticated");
        }
        this.checkClientProtocol(authClient);
        return true;
    }

    private Failure unauthorized(String errorDescription) {
        this.event.detail("reason", errorDescription).error("invalid_token");
        throw new ErrorResponseException("invalid_token", errorDescription, Response.Status.UNAUTHORIZED);
    }

    private Failure forbidden() {
        return this.forbidden("Forbidden");
    }

    private Failure forbidden(String errorDescription) {
        this.event.error("not_allowed");
        throw new ErrorResponseException("insufficient_scope", errorDescription, Response.Status.FORBIDDEN);
    }

    private Failure notFound() {
        this.event.error("client_not_found");
        throw new ErrorResponseException("invalid_request", "Client not found", Response.Status.NOT_FOUND);
    }
}

