/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.tomcat.SimpleGroup;
import org.keycloak.adapters.tomcat.SimplePrincipal;

public abstract class GenericPrincipalFactory {
    public GenericPrincipal createPrincipal(Realm realm, Principal identity, Set<String> roleSet, KeycloakSecurityContext securityContext) {
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(identity);
        Group[] roleSets = this.getRoleSets(roleSet);
        for (int g = 0; g < roleSets.length; ++g) {
            Group group = roleSets[g];
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        Principal userPrincipal = this.getPrincipal(subject);
        ArrayList<String> rolesAsStringList = new ArrayList<String>();
        rolesAsStringList.addAll(roleSet);
        GenericPrincipal principal = this.createPrincipal(userPrincipal, rolesAsStringList);
        return principal;
    }

    protected abstract GenericPrincipal createPrincipal(Principal var1, List<String> var2);

    protected Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                if (p instanceof Group || principal != null) continue;
                principal = p;
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            Group grp;
            if (!(next instanceof Group) || !(grp = (Group)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    protected Group[] getRoleSets(Collection<String> roleSet) {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (String role : roleSet) {
            roles.addMember(new SimplePrincipal(role));
        }
        return roleSets;
    }
}

