/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jaas;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.keycloak.VerificationException;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.jaas.AbstractKeycloakLoginModule;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;

public class DirectAccessGrantsLoginModule
extends AbstractKeycloakLoginModule {
    private static final Logger log = Logger.getLogger(DirectAccessGrantsLoginModule.class);
    private String refreshToken;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        Iterator<RefreshTokenHolder> iterator = subject.getPrivateCredentials(RefreshTokenHolder.class).iterator();
        if (iterator.hasNext()) {
            this.refreshToken = iterator.next().refreshToken;
        }
    }

    @Override
    protected AbstractKeycloakLoginModule.Auth doAuth(String username, String password) throws IOException, VerificationException {
        return this.directGrantAuth(username, password);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    protected AbstractKeycloakLoginModule.Auth directGrantAuth(String username, String password) throws IOException, VerificationException {
        String authServerBaseUrl = this.deployment.getAuthServerBaseUrl();
        URI directGrantUri = KeycloakUriBuilder.fromUri((String)authServerBaseUrl).path("/realms/{realm-name}/protocol/openid-connect/token").build(new Object[]{this.deployment.getRealm()});
        HttpPost post = new HttpPost(directGrantUri);
        ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add((NameValuePair)new BasicNameValuePair("grant_type", "password"));
        formparams.add((NameValuePair)new BasicNameValuePair("username", username));
        formparams.add((NameValuePair)new BasicNameValuePair("password", password));
        ClientCredentialsProviderUtils.setClientCredentials(this.deployment, post, formparams);
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        HttpClient client = this.deployment.getClient();
        HttpResponse response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            StringBuilder errorBuilder = new StringBuilder("Login failed. Invalid status: " + status);
            if (entity != null) {
                InputStream is = entity.getContent();
                Map errors = (Map)JsonSerialization.readValue((InputStream)is, Map.class);
                errorBuilder.append(", OAuth2 error. Error: " + (String)errors.get("error")).append(", Error description: " + (String)errors.get("error_description"));
            }
            String error = errorBuilder.toString();
            log.warn((Object)error);
            throw new IOException(error);
        }
        if (entity == null) {
            throw new IOException("No Entity");
        }
        InputStream is = entity.getContent();
        AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((InputStream)is, AccessTokenResponse.class);
        this.refreshToken = tokenResponse.getRefreshToken();
        return this.bearerAuth(tokenResponse.getToken());
    }

    @Override
    public boolean commit() throws LoginException {
        boolean superCommit = super.commit();
        if (this.refreshToken != null) {
            RefreshTokenHolder refreshTokenHolder = new RefreshTokenHolder();
            refreshTokenHolder.refreshToken = this.refreshToken;
            this.subject.getPrivateCredentials().add(refreshTokenHolder);
        }
        return superCommit;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.refreshToken != null) {
            try {
                URI logoutUri = this.deployment.getLogoutUrl().clone().build(new Object[0]);
                HttpPost post = new HttpPost(logoutUri);
                ArrayList<NameValuePair> formparams = new ArrayList<NameValuePair>();
                ClientCredentialsProviderUtils.setClientCredentials(this.deployment, post, formparams);
                formparams.add((NameValuePair)new BasicNameValuePair("refresh_token", this.refreshToken));
                UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
                post.setEntity((HttpEntity)form);
                HttpClient client = this.deployment.getClient();
                HttpResponse response = client.execute((HttpUriRequest)post);
                int status = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (status != 204) {
                    StringBuilder errorBuilder = new StringBuilder("Logout of refreshToken failed. Invalid status: " + status);
                    if (entity != null) {
                        InputStream is = entity.getContent();
                        if (status == 400) {
                            Map errors = (Map)JsonSerialization.readValue((InputStream)is, Map.class);
                            errorBuilder.append(", OAuth2 error. Error: " + (String)errors.get("error")).append(", Error description: " + (String)errors.get("error_description"));
                        } else if (is != null) {
                            is.close();
                        }
                    }
                    log.warn((Object)errorBuilder.toString());
                }
            }
            catch (IOException ioe) {
                log.warn((Object)ioe);
            }
        }
        return super.logout();
    }

    private static class RefreshTokenHolder
    implements Serializable {
        private String refreshToken;

        private RefreshTokenHolder() {
        }
    }
}

