/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PartialImportRepresentation {
    protected Policy policy = Policy.FAIL;
    protected String ifResourceExists = "";
    protected List<UserRepresentation> users;
    protected List<ClientRepresentation> clients;
    protected List<IdentityProviderRepresentation> identityProviders;
    protected RolesRepresentation roles;

    public boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    public boolean hasClients() {
        return this.clients != null && !this.clients.isEmpty();
    }

    public boolean hasIdps() {
        return this.identityProviders != null && !this.identityProviders.isEmpty();
    }

    public boolean hasRealmRoles() {
        return this.roles != null && this.roles.getRealm() != null && !this.roles.getRealm().isEmpty();
    }

    public boolean hasClientRoles() {
        return this.roles != null && this.roles.getClient() != null && !this.roles.getClient().isEmpty();
    }

    public String getIfResourceExists() {
        return this.ifResourceExists;
    }

    public void setIfResourceExists(String ifResourceExists) {
        this.ifResourceExists = ifResourceExists;
        this.policy = Policy.valueOf(ifResourceExists);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public List<UserRepresentation> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserRepresentation> users) {
        this.users = users;
    }

    public List<ClientRepresentation> getClients() {
        return this.clients;
    }

    public void setClients(List<ClientRepresentation> clients) {
        this.clients = clients;
    }

    public List<IdentityProviderRepresentation> getIdentityProviders() {
        return this.identityProviders;
    }

    public void setIdentityProviders(List<IdentityProviderRepresentation> identityProviders) {
        this.identityProviders = identityProviders;
    }

    public RolesRepresentation getRoles() {
        return this.roles;
    }

    public void setRoles(RolesRepresentation roles) {
        this.roles = roles;
    }

    public static enum Policy {
        SKIP,
        OVERWRITE,
        FAIL;

    }
}

