/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.tomcat.AuthenticatedActionsValve;
import org.keycloak.adapters.tomcat.CatalinaCookieTokenStore;
import org.keycloak.adapters.tomcat.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat.CatalinaRequestAuthenticator;
import org.keycloak.adapters.tomcat.CatalinaSessionTokenStore;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagementWrapper;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;
import org.keycloak.adapters.tomcat.OIDCCatalinaHttpFacade;
import org.keycloak.enums.TokenStore;

public abstract class AbstractKeycloakAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    public static final String TOKEN_STORE_NOTE = "TOKEN_STORE_NOTE";
    private static final Logger log = Logger.getLogger("" + AbstractKeycloakAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected AdapterDeploymentContext deploymentContext;
    protected NodesRegistrationManagement nodesRegistrationManagement;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.cache = false;
        } else if ("after_start".equals(event.getType())) {
            this.keycloakInit();
        } else if (event.getType() == "before_stop") {
            this.beforeStop();
        }
    }

    protected void logoutInternal(Request request) {
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (ksc != null) {
            OIDCCatalinaHttpFacade facade = new OIDCCatalinaHttpFacade(request, null);
            KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
            if (ksc instanceof RefreshableKeycloakSecurityContext) {
                ((RefreshableKeycloakSecurityContext)ksc).logout(deployment);
            }
            AdapterTokenStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
            tokenStore.logout();
            request.removeAttribute(KeycloakSecurityContext.class.getName());
        }
        request.setUserPrincipal(null);
    }

    protected void beforeStop() {
        if (this.nodesRegistrationManagement != null) {
            this.nodesRegistrationManagement.stop();
        }
    }

    public void keycloakInit() {
        String configResolverClass = this.context.getServletContext().getInitParameter("keycloak.config.resolver");
        if (configResolverClass != null) {
            try {
                KeycloakConfigResolver configResolver = (KeycloakConfigResolver)this.context.getLoader().getClassLoader().loadClass(configResolverClass).newInstance();
                this.deploymentContext = new AdapterDeploymentContext(configResolver);
                log.log(Level.INFO, "Using {0} to resolve Keycloak configuration on a per-request basis.", configResolverClass);
            }
            catch (Exception ex) {
                log.log(Level.FINE, "The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
                this.deploymentContext = new AdapterDeploymentContext(new KeycloakDeployment());
            }
        } else {
            KeycloakDeployment kd;
            InputStream configInputStream = AbstractKeycloakAuthenticatorValve.getConfigInputStream(this.context);
            if (configInputStream == null) {
                log.warning("No adapter configuration. Keycloak is unconfigured and will deny all requests.");
                kd = new KeycloakDeployment();
            } else {
                kd = KeycloakDeploymentBuilder.build((InputStream)configInputStream);
            }
            this.deploymentContext = new AdapterDeploymentContext(kd);
            log.fine("Keycloak is using a per-deployment configuration.");
        }
        this.context.getServletContext().setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.deploymentContext, this.getNext(), this.getContainer());
        this.setNext((Valve)actions);
        this.nodesRegistrationManagement = new NodesRegistrationManagement();
    }

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        log.finest("**** using org.keycloak.json.adapterConfig");
        log.finest(json);
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = AbstractKeycloakAuthenticatorValve.getJSONFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.finest("**** using /WEB-INF/keycloak.json");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    log.log(Level.SEVERE, "NOT FOUND {0}", path);
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        OIDCCatalinaHttpFacade facade = new OIDCCatalinaHttpFacade(request, (HttpServletResponse)response);
        Manager sessionManager = request.getContext().getManager();
        CatalinaUserSessionManagementWrapper sessionManagementWrapper = new CatalinaUserSessionManagementWrapper(this.userSessionManagement, sessionManager);
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)sessionManagementWrapper, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.checkKeycloakSession(request, (HttpFacade)facade);
        super.invoke(request, response);
    }

    protected abstract GenericPrincipalFactory createPrincipalFactory();

    protected abstract boolean forwardToErrorPageInternal(Request var1, HttpServletResponse var2, Object var3) throws IOException;

    protected boolean authenticateInternal(Request request, HttpServletResponse response, Object loginConfig) throws IOException {
        OIDCCatalinaHttpFacade facade = new OIDCCatalinaHttpFacade(request, response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            facade.getResponse().sendError(401);
            return false;
        }
        AdapterTokenStore tokenStore = this.getTokenStore(request, (HttpFacade)facade, deployment);
        this.nodesRegistrationManagement.tryRegister(deployment);
        CatalinaRequestAuthenticator authenticator = this.createRequestAuthenticator(request, facade, deployment, tokenStore);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            return !facade.isEnded();
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    protected CatalinaRequestAuthenticator createRequestAuthenticator(Request request, CatalinaHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new CatalinaRequestAuthenticator(deployment, tokenStore, facade, request, this.createPrincipalFactory());
    }

    protected void checkKeycloakSession(Request request, HttpFacade facade) {
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment(facade);
        AdapterTokenStore tokenStore = this.getTokenStore(request, facade, deployment);
        tokenStore.checkCurrentToken();
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AdapterTokenStore getTokenStore(Request request, HttpFacade facade, KeycloakDeployment resolvedDeployment) {
        Object store = (AdapterTokenStore)request.getNote(TOKEN_STORE_NOTE);
        if (store != null) {
            return store;
        }
        store = resolvedDeployment.getTokenStore() == TokenStore.SESSION ? this.createSessionTokenStore(request, resolvedDeployment) : new CatalinaCookieTokenStore(request, facade, resolvedDeployment, this.createPrincipalFactory());
        request.setNote(TOKEN_STORE_NOTE, store);
        return store;
    }

    private AdapterTokenStore createSessionTokenStore(Request request, KeycloakDeployment resolvedDeployment) {
        CatalinaSessionTokenStore store = new CatalinaSessionTokenStore(request, resolvedDeployment, this.userSessionManagement, this.createPrincipalFactory(), this);
        return store;
    }
}

