/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.adapters.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class PolicyEnforcerConfig {
    @JsonProperty(value="create-resources")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean createResources = Boolean.FALSE;
    @JsonProperty(value="enforcement-mode")
    private EnforcementMode enforcementMode = EnforcementMode.ENFORCING;
    @JsonProperty(value="user-managed-access")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UmaProtocolConfig userManagedAccess;
    @JsonProperty(value="entitlement")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EntitlementProtocolConfig entitlement;
    @JsonProperty(value="paths")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<PathConfig> paths = new ArrayList<PathConfig>();
    @JsonProperty(value="online-introspection")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean onlineIntrospection = Boolean.FALSE;
    @JsonProperty(value="on-deny-redirect-to")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String onDenyRedirectTo;

    public Boolean isCreateResources() {
        return this.createResources;
    }

    public List<PathConfig> getPaths() {
        return this.paths;
    }

    public EnforcementMode getEnforcementMode() {
        return this.enforcementMode;
    }

    public void setEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
    }

    public UmaProtocolConfig getUserManagedAccess() {
        return this.userManagedAccess;
    }

    public EntitlementProtocolConfig getEntitlement() {
        return this.entitlement;
    }

    public Boolean isOnlineIntrospection() {
        return this.onlineIntrospection;
    }

    public void setCreateResources(Boolean createResources) {
        this.createResources = createResources;
    }

    public void setOnlineIntrospection(Boolean onlineIntrospection) {
        this.onlineIntrospection = onlineIntrospection;
    }

    public void setPaths(List<PathConfig> paths) {
        this.paths = paths;
    }

    public String getOnDenyRedirectTo() {
        return this.onDenyRedirectTo;
    }

    public void setUserManagedAccess(UmaProtocolConfig userManagedAccess) {
        this.userManagedAccess = userManagedAccess;
    }

    public void setEntitlement(EntitlementProtocolConfig entitlement) {
        this.entitlement = entitlement;
    }

    public void setOnDenyRedirectTo(String onDenyRedirectTo) {
        this.onDenyRedirectTo = onDenyRedirectTo;
    }

    public static class EntitlementProtocolConfig {
    }

    public static class UmaProtocolConfig {
    }

    public static enum ScopeEnforcementMode {
        ALL,
        ANY;

    }

    public static enum EnforcementMode {
        PERMISSIVE,
        ENFORCING,
        DISABLED;

    }

    public static class MethodConfig {
        private String method;
        private List<String> scopes = new ArrayList<String>();
        @JsonProperty(value="scopes-enforcement-mode")
        private ScopeEnforcementMode scopesEnforcementMode = ScopeEnforcementMode.ALL;

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public void setScopesEnforcementMode(ScopeEnforcementMode scopesEnforcementMode) {
            this.scopesEnforcementMode = scopesEnforcementMode;
        }

        public ScopeEnforcementMode getScopesEnforcementMode() {
            return this.scopesEnforcementMode;
        }
    }

    public static class PathConfig {
        private String name;
        private String type;
        private String path;
        private List<MethodConfig> methods = new ArrayList<MethodConfig>();
        private List<String> scopes = new ArrayList<String>();
        private String id;
        @JsonProperty(value="enforcement-mode")
        private EnforcementMode enforcementMode = EnforcementMode.ENFORCING;
        @JsonIgnore
        private PathConfig parentConfig;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        public List<MethodConfig> getMethods() {
            return this.methods;
        }

        public void setMethods(List<MethodConfig> methods) {
            this.methods = methods;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public EnforcementMode getEnforcementMode() {
            return this.enforcementMode;
        }

        public void setEnforcementMode(EnforcementMode enforcementMode) {
            this.enforcementMode = enforcementMode;
        }

        public String toString() {
            return "PathConfig{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", path='" + this.path + '\'' + ", scopes=" + this.scopes + ", id='" + this.id + '\'' + ", enforcerMode='" + (Object)((Object)this.enforcementMode) + '\'' + '}';
        }

        @JsonIgnore
        public boolean hasPattern() {
            return this.getPath().indexOf("{") != -1;
        }

        @JsonIgnore
        public boolean isInstance() {
            return this.parentConfig != null;
        }

        public void setParentConfig(PathConfig parentConfig) {
            this.parentConfig = parentConfig;
        }

        public PathConfig getParentConfig() {
            return this.parentConfig;
        }
    }
}

