/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.IOException;
import java.util.List;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;

public class CatalinaUserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(CatalinaUserSessionManagement.class);

    public void login(Session session) {
        session.addSessionListener((SessionListener)this);
    }

    public void logoutAll(Manager sessionManager) {
        Session[] allSessions;
        for (Session session : allSessions = sessionManager.findSessions()) {
            this.logoutSession(session);
        }
    }

    public void logoutHttpSessions(Manager sessionManager, List<String> sessionIds) {
        log.debug((Object)("logoutHttpSessions: " + sessionIds));
        for (String sessionId : sessionIds) {
            this.logoutSession(sessionManager, sessionId);
        }
    }

    protected void logoutSession(Manager manager, String httpSessionId) {
        Session session;
        log.debug((Object)("logoutHttpSession: " + httpSessionId));
        try {
            session = manager.findSession(httpSessionId);
        }
        catch (IOException ioe) {
            log.warn((Object)("IO exception when looking for session " + httpSessionId), (Throwable)ioe);
            return;
        }
        this.logoutSession(session);
    }

    protected void logoutSession(Session session) {
        try {
            if (session != null) {
                session.expire();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Session not present or already invalidated.", (Throwable)e);
        }
    }

    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        log.debugf("Session %s destroyed", (Object)session.getId());
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            return;
        }
        session.setPrincipal(null);
        session.setAuthType(null);
    }
}

