/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletSessionConfig;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.config.RealmConfiguration;
import org.keycloak.adapters.config.RealmConfigurationLoader;
import org.keycloak.adapters.undertow.PreflightCorsHandler;
import org.keycloak.adapters.undertow.ServletAdminActionsHandler;
import org.keycloak.adapters.undertow.ServletAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.ServletKeycloakAuthenticationMechanism;
import org.keycloak.adapters.undertow.ServletPropagateSessionHandler;
import org.keycloak.adapters.undertow.UserSessionManagement;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class KeycloakServletExtension
implements ServletExtension {
    protected Logger log = Logger.getLogger(KeycloakServletExtension.class);

    public boolean isAuthenticationMechanismPresent(DeploymentInfo deploymentInfo, String mechanismName) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null) {
            for (AuthMethodConfig method : loginConfig.getAuthMethods()) {
                if (!method.getName().equalsIgnoreCase(mechanismName)) continue;
                return true;
            }
        }
        return false;
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        if (!this.isAuthenticationMechanismPresent(deploymentInfo, "KEYCLOAK")) {
            this.log.info((Object)"auth-method is not keycloak!");
            return;
        }
        this.log.info((Object)"KeycloakServletException initialization");
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/keycloak.json");
        if (is == null) {
            throw new RuntimeException("Unable to find /WEB-INF/keycloak.json configuration file");
        }
        RealmConfigurationLoader loader = new RealmConfigurationLoader(is);
        loader.init(true);
        AdapterConfig keycloakConfig = loader.getAdapterConfig();
        RealmConfiguration realmConfiguration = loader.getRealmConfiguration();
        PreflightCorsHandler.Wrapper preflight = new PreflightCorsHandler.Wrapper(keycloakConfig);
        UserSessionManagement userSessionManagement = new UserSessionManagement(realmConfiguration);
        ServletKeycloakAuthenticationMechanism auth = null;
        auth = keycloakConfig.isBearerOnly() ? new ServletKeycloakAuthenticationMechanism(keycloakConfig, loader.getResourceMetadata(), deploymentInfo.getConfidentialPortManager()) : new ServletKeycloakAuthenticationMechanism(userSessionManagement, keycloakConfig, realmConfiguration, deploymentInfo.getConfidentialPortManager());
        ServletAuthenticatedActionsHandler.Wrapper actions = new ServletAuthenticatedActionsHandler.Wrapper(keycloakConfig);
        deploymentInfo.addInitialHandlerChainWrapper((HandlerWrapper)preflight);
        deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new ServletAdminActionsHandler.Wrapper(realmConfiguration, userSessionManagement));
        final ServletKeycloakAuthenticationMechanism theAuth = auth;
        deploymentInfo.addAuthenticationMechanism("KEYCLOAK", new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String s, FormParserFactory formParserFactory, Map<String, String> stringStringMap) {
                return theAuth;
            }
        });
        deploymentInfo.addInnerHandlerChainWrapper(ServletPropagateSessionHandler.WRAPPER);
        deploymentInfo.addInnerHandlerChainWrapper((HandlerWrapper)actions);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                KeycloakServletExtension.this.log.info((Object)"Verifying account in IdentityManager");
                return account;
            }

            public Account verify(String id, Credential credential) {
                KeycloakServletExtension.this.log.warn((Object)"Shouldn't call verify!!!");
                throw new IllegalStateException("Not allowed");
            }

            public Account verify(Credential credential) {
                KeycloakServletExtension.this.log.warn((Object)"Shouldn't call verify!!!");
                throw new IllegalStateException("Not allowed");
            }
        });
        this.log.info((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
        ServletSessionConfig cookieConfig = new ServletSessionConfig();
        cookieConfig.setPath(deploymentInfo.getContextPath());
        deploymentInfo.setServletSessionConfig(cookieConfig);
    }
}

