/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.NormalizingComparator;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.loader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.factory.AvlPartitionFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.i18n.I18n;
import org.jboss.logging.Logger;
import org.keycloak.util.ldap.InMemorySchemaPartition;

class InMemoryDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static final Logger log = Logger.getLogger(InMemoryDirectoryServiceFactory.class);
    private final DirectoryService directoryService;
    private final PartitionFactory partitionFactory;

    public InMemoryDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.directoryService.setShutdownHookEnabled(false);
        this.partitionFactory = new AvlPartitionFactory();
    }

    public InMemoryDirectoryServiceFactory(DirectoryService directoryService, PartitionFactory partitionFactory) {
        this.directoryService = directoryService;
        this.partitionFactory = partitionFactory;
    }

    public void init(String name) throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.directoryService.setInstanceId(name);
        InstanceLayout instanceLayout = new InstanceLayout(System.getProperty("java.io.tmpdir") + "/server-work-inmemory-" + name);
        if (instanceLayout.getInstanceDirectory().exists()) {
            try {
                FileUtils.deleteDirectory((File)instanceLayout.getInstanceDirectory());
            }
            catch (IOException e) {
                log.warn((Object)"couldn't delete the instance directory before initializing the DirectoryService", (Throwable)e);
            }
        }
        this.directoryService.setInstanceLayout(instanceLayout);
        Configuration ehCacheConfig = new Configuration();
        CacheConfiguration defaultCache = new CacheConfiguration("default", 1).eternal(false).timeToIdleSeconds(30L).timeToLiveSeconds(30L).overflowToDisk(false);
        ehCacheConfig.addDefaultCache(defaultCache);
        CacheService cacheService = new CacheService(new CacheManager(ehCacheConfig));
        this.directoryService.setCacheService(cacheService);
        JarLdifSchemaLoader loader = new JarLdifSchemaLoader();
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        ComparatorRegistry comparatorRegistry = schemaManager.getComparatorRegistry();
        for (LdapComparator comparator : comparatorRegistry) {
            if (!(comparator instanceof NormalizingComparator)) continue;
            ((NormalizingComparator)comparator).setOnServer();
        }
        this.directoryService.setSchemaManager((SchemaManager)schemaManager);
        InMemorySchemaPartition inMemorySchemaPartition = new InMemorySchemaPartition((SchemaManager)schemaManager);
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)inMemorySchemaPartition);
        this.directoryService.setSchemaPartition(schemaPartition);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err((I18n)I18n.ERR_317, (Object[])new Object[]{Exceptions.printErrors((List)errors)}));
        }
        Partition systemPartition = this.partitionFactory.createPartition(this.directoryService.getSchemaManager(), this.directoryService.getDnFactory(), "system", "ou=system", 500, new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }
}

