/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.account.AccountPages;
import org.keycloak.account.AccountProvider;
import org.keycloak.account.freemarker.Templates;
import org.keycloak.account.freemarker.model.AccountBean;
import org.keycloak.account.freemarker.model.AccountSocialBean;
import org.keycloak.account.freemarker.model.FeaturesBean;
import org.keycloak.account.freemarker.model.LogBean;
import org.keycloak.account.freemarker.model.MessageBean;
import org.keycloak.account.freemarker.model.ReferrerBean;
import org.keycloak.account.freemarker.model.SessionsBean;
import org.keycloak.account.freemarker.model.TotpBean;
import org.keycloak.account.freemarker.model.UrlBean;
import org.keycloak.audit.Event;
import org.keycloak.freemarker.ExtendingThemeManager;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.FreeMarkerUtil;
import org.keycloak.freemarker.Theme;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.ProviderSession;

public class FreeMarkerAccountProvider
implements AccountProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerAccountProvider.class);
    private UserModel user;
    private Response.Status status = Response.Status.OK;
    private RealmModel realm;
    private String[] referrer;
    private List<Event> events;
    private List<UserSessionModel> sessions;
    private boolean social;
    private boolean audit;
    private boolean passwordUpdateSupported;
    private ProviderSession session;
    private FreeMarkerUtil freeMarker;
    private UriInfo uriInfo;
    private String message;
    private MessageType messageType;

    public FreeMarkerAccountProvider(ProviderSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
    }

    public AccountProvider setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public Response createResponse(AccountPages page) {
        Properties messages;
        Theme theme;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ExtendingThemeManager themeManager = new ExtendingThemeManager(this.session);
        try {
            theme = themeManager.createTheme(this.realm.getAccountTheme(), Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        try {
            messages = theme.getMessages();
            attributes.put("rb", messages);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messages = new Properties();
        }
        URI baseUri = this.uriInfo.getBaseUri();
        UriBuilder baseUriBuilder = this.uriInfo.getBaseUriBuilder();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            baseUriBuilder.queryParam((String)e.getKey(), ((List)e.getValue()).toArray());
        }
        URI baseQueryUri = baseUriBuilder.build(new Object[0]);
        if (this.message != null) {
            attributes.put("message", new MessageBean(messages.containsKey(this.message) ? messages.getProperty(this.message) : this.message, this.messageType));
        }
        if (this.referrer != null) {
            attributes.put("referrer", new ReferrerBean(this.referrer));
        }
        attributes.put("url", new UrlBean(this.realm, theme, baseUri, baseQueryUri, this.uriInfo.getRequestUri()));
        attributes.put("features", new FeaturesBean(this.social, this.audit, this.passwordUpdateSupported));
        switch (page) {
            case ACCOUNT: {
                attributes.put("account", new AccountBean(this.user));
                break;
            }
            case TOTP: {
                attributes.put("totp", new TotpBean(this.user, baseUri));
                break;
            }
            case SOCIAL: {
                attributes.put("social", new AccountSocialBean(this.realm, this.user, this.uriInfo.getBaseUri()));
                break;
            }
            case LOG: {
                attributes.put("log", new LogBean(this.events));
                break;
            }
            case SESSIONS: {
                attributes.put("sessions", new SessionsBean(this.realm, this.sessions));
            }
        }
        try {
            String result = this.freeMarker.processTemplate(attributes, Templates.getTemplate(page), theme);
            return Response.status((Response.Status)this.status).type("text/html").entity((Object)result).build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public AccountProvider setError(String message) {
        this.message = message;
        this.messageType = MessageType.ERROR;
        return this;
    }

    public AccountProvider setSuccess(String message) {
        this.message = message;
        this.messageType = MessageType.SUCCESS;
        return this;
    }

    public AccountProvider setWarning(String message) {
        this.message = message;
        this.messageType = MessageType.WARNING;
        return this;
    }

    public AccountProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public AccountProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AccountProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public AccountProvider setReferrer(String[] referrer) {
        this.referrer = referrer;
        return this;
    }

    public AccountProvider setEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    public AccountProvider setSessions(List<UserSessionModel> sessions) {
        this.sessions = sessions;
        return this;
    }

    public AccountProvider setFeatures(boolean social, boolean audit, boolean passwordUpdateSupported) {
        this.social = social;
        this.audit = audit;
        this.passwordUpdateSupported = passwordUpdateSupported;
        return this;
    }

    public void close() {
    }

    public static enum MessageType {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

