/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.picketlink.realm;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.picketlink.idm.LDAPAgentIgnoreCredentialHandler;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.basic.User;

public class PartitionManagerRegistry {
    private static final Logger logger = Logger.getLogger(PartitionManagerRegistry.class);
    private Map<String, PartitionManagerContext> partitionManagers = new ConcurrentHashMap<String, PartitionManagerContext>();

    public PartitionManager getPartitionManager(RealmModel realm) {
        Map ldapConfig = realm.getLdapServerConfig();
        if (ldapConfig == null || ldapConfig.isEmpty()) {
            logger.warnf("Ldap configuration is missing for realm '%s'", (Object)realm.getName());
            return null;
        }
        PartitionManagerContext context = this.partitionManagers.get(realm.getId());
        if (context == null || !ldapConfig.equals(context.config)) {
            logger.infof("Creating new partition manager for the realm: %s, LDAP Connection URL: %s, LDAP Base DN: %s", (Object)realm.getId(), ldapConfig.get("connectionUrl"), ldapConfig.get("baseDn"));
            PartitionManager manager = this.createPartitionManager(ldapConfig);
            context = new PartitionManagerContext(ldapConfig, manager);
            this.partitionManagers.put(realm.getId(), context);
        }
        return context.partitionManager;
    }

    protected PartitionManager createPartitionManager(Map<String, String> ldapConfig) {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        Properties connectionProps = new Properties();
        connectionProps.put("com.sun.jndi.ldap.connect.pool", "true");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "10");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        this.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        ((LDAPStoreConfigurationBuilder)((LDAPStoreConfigurationBuilder)builder.named("SIMPLE_LDAP_STORE_CONFIG").stores().ldap().connectionProperties(connectionProps).addCredentialHandler(LDAPAgentIgnoreCredentialHandler.class)).baseDN(ldapConfig.get("baseDn")).bindDN(ldapConfig.get("bindDn")).bindCredential(ldapConfig.get("bindCredential")).url(ldapConfig.get("connectionUrl")).supportAllFeatures()).mapping(User.class).baseDN(ldapConfig.get("userDnSuffix")).objectClasses(new String[]{"inetOrgPerson", "organizationalPerson"}).attribute("loginName", "uid", true).attribute("firstName", "cn").attribute("lastName", "sn").attribute("email", "mail").readOnlyAttribute("createdDate", "createTimeStamp");
        return new DefaultPartitionManager((Collection)builder.buildAll());
    }

    private void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private class PartitionManagerContext {
        private Map<String, String> config;
        private PartitionManager partitionManager;

        private PartitionManagerContext(Map<String, String> config, PartitionManager manager) {
            this.config = config;
            this.partitionManager = manager;
        }
    }
}

